/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class SyntaxStylizer
implements PreferenceChangeListener {
    public static final int SYNTAX_DEFAULT = 0;
    public static final int SYNTAX_KEYWORD = 1;
    public static final int SYNTAX_FUNCTION = 2;
    public static final int SYNTAX_MLINE_COMMENT = 3;
    public static final int SYNTAX_SLINE_COMMENT = 4;
    public static final int SYNTAX_JDBC_OBJECT = 5;
    public static final int SYNTAX_STRING_LITERAL = 6;
    public static final int SYNTAX_SQL_PARAMETER = 7;
    public static final int SYNTAX_FOREIGN_OBJECT = 8;
    public static final int SYNTAX_PROCEDURES = 9;
    public static final int SYNTAX_TABLESPACES = 10;
    private SimpleAttributeSet[] defaults = new SimpleAttributeSet[11];
    private HashMap syntaxMap = new HashMap();
    private UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private SQLDocument syntaxView = null;
    private FunctionModel funcModel = new FunctionModel(null);

    public SyntaxStylizer(SQLDocument sQLDocument) {
        this.syntaxView = sQLDocument;
        this.initDefaults();
        this.addKeywords();
    }

    public void addKeyword(String string, int n2) {
        this.addKeyword(string, this.defaults[n2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyword(String string, AttributeSet attributeSet) {
        HashMap hashMap = this.syntaxMap;
        synchronized (hashMap) {
            this.syntaxMap.put(string.toUpperCase(), attributeSet);
        }
    }

    public AttributeSet getStyle(String string) {
        if (string == null) {
            return this.getDefaultStyle();
        }
        AttributeSet attributeSet = (AttributeSet)this.syntaxMap.get(string.toUpperCase());
        if (attributeSet == null) {
            attributeSet = this.getDefaultStyle();
        }
        return attributeSet;
    }

    public AttributeSet getLiteralStyle() {
        return this.defaults[6];
    }

    public AttributeSet getParameterStyle() {
        return this.defaults[7];
    }

    public AttributeSet getSingleCommentStyle() {
        return this.defaults[4];
    }

    public AttributeSet getMultiCommentStyle() {
        return this.defaults[3];
    }

    public AttributeSet getDefaultStyle() {
        return this.defaults[0];
    }

    public void updateDefaultFont(Font font) {
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.getDefaultStyle();
        if (font == null) {
            StyleConstants.setFontFamily(simpleAttributeSet, "Default");
            StyleConstants.setBold(simpleAttributeSet, false);
            StyleConstants.setItalic(simpleAttributeSet, false);
            StyleConstants.setFontSize(simpleAttributeSet, 12);
        } else {
            StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
            StyleConstants.setBold(simpleAttributeSet, font.isBold());
            StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
            StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
        }
    }

    public void updateDefaultForeground(Color color) {
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.getDefaultStyle();
        if (color == null) {
            StyleConstants.setForeground(simpleAttributeSet, UIManager.getColor("TextArea.foreground"));
        } else {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
    }

    public void updateDefaultBackground(Color color) {
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.getDefaultStyle();
        if (color == null) {
            StyleConstants.setBackground(simpleAttributeSet, UIManager.getColor("TextArea.background"));
        } else {
            StyleConstants.setBackground(simpleAttributeSet, color);
        }
    }

    public SuggestionListModel getFunctions() {
        return this.funcModel;
    }

    public int getStyleType(String string) {
        AttributeSet attributeSet = (AttributeSet)this.syntaxMap.get(string.toUpperCase());
        if (attributeSet == null) {
            return 0;
        }
        for (int i2 = 0; i2 < this.defaults.length; ++i2) {
            if (!attributeSet.equals(this.defaults[i2])) continue;
            return i2;
        }
        return 0;
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        String string2 = preferenceChangeEvent.getNewValue();
        SimpleAttributeSet simpleAttributeSet = null;
        SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)this.getDefaultStyle();
        if (string.equals("editor.font")) {
            Font font = StringUtilities.parseFontString(string2);
            StyleConstants.setFontFamily(simpleAttributeSet2, font.getFamily());
            StyleConstants.setFontSize(simpleAttributeSet2, font.getSize());
            StyleConstants.setBold(simpleAttributeSet2, font.isBold());
            StyleConstants.setItalic(simpleAttributeSet2, font.isItalic());
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.background-color")) {
            Color color = Color.decode(string2);
            StyleConstants.setBackground(simpleAttributeSet2, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.default-color")) {
            Color color = Color.decode(string2);
            StyleConstants.setForeground(simpleAttributeSet2, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.multicomment-color")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[3];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.sline-comments")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[4];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.functions")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[2];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.literals")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[6];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.local-obj")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[2];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        } else if (string.equals("editor.sql-keywords")) {
            Color color = Color.decode(string2);
            simpleAttributeSet = this.defaults[1];
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.syntaxView.validateStyles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(DatabaseConnection databaseConnection) {
        this.reset();
        if (databaseConnection == null) {
            return;
        }
        DatabaseMetaData databaseMetaData = databaseConnection.getDatabaseInformation();
        try {
            this.addObjects(databaseConnection.getAvailableCatalogs(), 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addObjects(databaseConnection.getAvailableSchemas(), 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ResultSet resultSet = null;
        try {
            String string = databaseConnection.getSchema();
            resultSet = databaseMetaData.getTables(databaseConnection.getCatalog(), null, "%", databaseConnection.getTableTypes());
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                String string3 = resultSet.getString("TABLE_SCHEM");
                if (string3 != null && string != null && string3.equals(string)) {
                    this.addKeywords(string2, 5);
                    continue;
                }
                this.addKeywords(string2, 8);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
        try {
            this.addObjects(databaseConnection.getProcedures(), 9);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(databaseMetaData.getStringFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(databaseMetaData.getSystemFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(databaseMetaData.getTimeDateFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(databaseMetaData.getNumericFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(databaseMetaData.getProcedureTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(databaseMetaData.getCatalogTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(databaseMetaData.getSchemaTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(databaseMetaData.getSQLKeywords(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.syntaxView.validateStyles();
    }

    public void addKeywords(String string, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.addKeyword(string2, n2);
            if (n2 != 2 || this.funcModel.rootStore.contains(string2)) continue;
            this.funcModel.rootStore.add(string2);
        }
    }

    public void addObjects(Object[] objectArray, int n2) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.addKeyword(objectArray[i2].toString(), n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        HashMap hashMap = this.syntaxMap;
        synchronized (hashMap) {
            this.syntaxMap.clear();
            this.funcModel.clear();
        }
        this.addKeywords();
    }

    private void addKeywords() {
        this.addKeyword("ABSOLUTE", 1);
        this.addKeyword("ACTION", 1);
        this.addKeyword("ADD", 1);
        this.addKeyword("ADMIN", 1);
        this.addKeyword("AFTER", 1);
        this.addKeyword("AGGREGATE", 1);
        this.addKeyword("ALIAS", 1);
        this.addKeyword("ALL", 1);
        this.addKeyword("ALLOCATE", 1);
        this.addKeyword("ALTER", 1);
        this.addKeyword("AND", 1);
        this.addKeyword("ANY", 1);
        this.addKeyword("ARE", 1);
        this.addKeyword("ARRAY", 1);
        this.addKeyword("AS", 1);
        this.addKeyword("ASC", 1);
        this.addKeyword("ASSERTION", 1);
        this.addKeyword("AT", 1);
        this.addKeyword("AUTHORIZATION", 1);
        this.addKeyword("BEFORE", 1);
        this.addKeyword("BEGIN", 1);
        this.addKeyword("BINARY", 1);
        this.addKeyword("BIT", 1);
        this.addKeyword("BLOB", 1);
        this.addKeyword("BOOLEAN", 1);
        this.addKeyword("BOTH", 1);
        this.addKeyword("BREADTH", 1);
        this.addKeyword("BY", 1);
        this.addKeyword("CALL", 1);
        this.addKeyword("CASCADE", 1);
        this.addKeyword("CASCADED", 1);
        this.addKeyword("CASE", 1);
        this.addKeyword("CAST", 1);
        this.addKeyword("CATALOG", 1);
        this.addKeyword("CHAR", 1);
        this.addKeyword("CHARACTER", 1);
        this.addKeyword("CHECK", 1);
        this.addKeyword("CLASS", 1);
        this.addKeyword("CLOB", 1);
        this.addKeyword("CLOSE", 1);
        this.addKeyword("COLLATE", 1);
        this.addKeyword("COLLATION", 1);
        this.addKeyword("COLUMN", 1);
        this.addKeyword("COMMIT", 1);
        this.addKeyword("COMPLETION", 1);
        this.addKeyword("CONDITION", 1);
        this.addKeyword("CONNECT", 1);
        this.addKeyword("CONNECTION", 1);
        this.addKeyword("CONSTRAINT", 1);
        this.addKeyword("CONSTRAINTS", 1);
        this.addKeyword("CONSTRUCTOR", 1);
        this.addKeyword("CONTAINS", 1);
        this.addKeyword("CONTINUE", 1);
        this.addKeyword("CORRESPONDING", 1);
        this.addKeyword("CREATE", 1);
        this.addKeyword("CROSS", 1);
        this.addKeyword("CUBE", 1);
        this.addKeyword("CURRENT", 1);
        this.addKeyword("CURRENT_DATE", 1);
        this.addKeyword("CURRENT_PATH", 1);
        this.addKeyword("CURRENT_ROLE", 1);
        this.addKeyword("CURRENT_TIME", 1);
        this.addKeyword("CURRENT_TIMESTAMP", 1);
        this.addKeyword("CURRENT_USER", 1);
        this.addKeyword("CURSOR", 1);
        this.addKeyword("CYCLE", 1);
        this.addKeyword("DATA", 1);
        this.addKeyword("DATALINK", 1);
        this.addKeyword("DATE", 1);
        this.addKeyword("DAY", 1);
        this.addKeyword("DEALLOCATE", 1);
        this.addKeyword("DEC", 1);
        this.addKeyword("DECIMAL", 1);
        this.addKeyword("DECLARE", 1);
        this.addKeyword("DEFAULT", 1);
        this.addKeyword("DEFERRABLE", 1);
        this.addKeyword("DELETE", 1);
        this.addKeyword("DEPTH", 1);
        this.addKeyword("DEREF", 1);
        this.addKeyword("DESC", 1);
        this.addKeyword("DESCRIPTOR", 1);
        this.addKeyword("DIAGNOSTICS", 1);
        this.addKeyword("DICTIONARY", 1);
        this.addKeyword("DISCONNECT", 1);
        this.addKeyword("DO", 1);
        this.addKeyword("DOMAIN", 1);
        this.addKeyword("DOUBLE", 1);
        this.addKeyword("DROP", 1);
        this.addKeyword("END-EXEC", 1);
        this.addKeyword("EQUALS", 1);
        this.addKeyword("ESCAPE", 1);
        this.addKeyword("EXCEPT", 1);
        this.addKeyword("EXCEPTION", 1);
        this.addKeyword("EXECUTE", 1);
        this.addKeyword("EXIT", 1);
        this.addKeyword("EXPAND", 1);
        this.addKeyword("EXPANDING", 1);
        this.addKeyword("FALSE", 1);
        this.addKeyword("FIRST", 1);
        this.addKeyword("FLOAT", 1);
        this.addKeyword("FOR", 1);
        this.addKeyword("FOREIGN", 1);
        this.addKeyword("FREE", 1);
        this.addKeyword("FROM", 1);
        this.addKeyword("FUNCTION", 1);
        this.addKeyword("GENERAL", 1);
        this.addKeyword("GET", 1);
        this.addKeyword("GLOBAL", 1);
        this.addKeyword("GOTO", 1);
        this.addKeyword("GROUP", 1);
        this.addKeyword("GROUPING", 1);
        this.addKeyword("HANDLER", 1);
        this.addKeyword("HASH", 1);
        this.addKeyword("HOUR", 1);
        this.addKeyword("IDENTITY", 1);
        this.addKeyword("IF", 1);
        this.addKeyword("IGNORE", 1);
        this.addKeyword("IMMEDUATE", 1);
        this.addKeyword("IN", 1);
        this.addKeyword("INDICATOR", 1);
        this.addKeyword("INITIALIZE", 1);
        this.addKeyword("INITALLY", 1);
        this.addKeyword("INNER", 1);
        this.addKeyword("INOUT", 1);
        this.addKeyword("INPUT", 1);
        this.addKeyword("INSERT", 1);
        this.addKeyword("INT", 1);
        this.addKeyword("INTEGER", 1);
        this.addKeyword("INTERSECT", 1);
        this.addKeyword("INTERVAL", 1);
        this.addKeyword("INTO", 1);
        this.addKeyword("IS", 1);
        this.addKeyword("ISOLATION", 1);
        this.addKeyword("ITERATE", 1);
        this.addKeyword("JOIN", 1);
        this.addKeyword("KEY", 1);
        this.addKeyword("LANGUAGE", 1);
        this.addKeyword("LARGE", 1);
        this.addKeyword("LAST", 1);
        this.addKeyword("LATERAL", 1);
        this.addKeyword("LEADING", 1);
        this.addKeyword("LEAVE", 1);
        this.addKeyword("LEFT", 1);
        this.addKeyword("LESS", 1);
        this.addKeyword("LEVEL", 1);
        this.addKeyword("LIKE", 1);
        this.addKeyword("LIMIT", 1);
        this.addKeyword("LOCAL", 1);
        this.addKeyword("LOCALTIME", 1);
        this.addKeyword("LOCALTIME-", 1);
        this.addKeyword("LOCATOR", 1);
        this.addKeyword("LOOP", 1);
        this.addKeyword("MATCH", 1);
        this.addKeyword("MEETS", 1);
        this.addKeyword("MINUTE", 1);
        this.addKeyword("MODIFIES", 1);
        this.addKeyword("MODIFY", 1);
        this.addKeyword("MODULE", 1);
        this.addKeyword("MONTH", 1);
        this.addKeyword("NAMES", 1);
        this.addKeyword("NATIONAL", 1);
        this.addKeyword("NATURAL", 1);
        this.addKeyword("NCHAR", 1);
        this.addKeyword("NCLOB", 1);
        this.addKeyword("NEW", 1);
        this.addKeyword("NEXT", 1);
        this.addKeyword("NO", 1);
        this.addKeyword("NONE", 1);
        this.addKeyword("NORMALIZE", 1);
        this.addKeyword("NOT", 1);
        this.addKeyword("NULL", 1);
        this.addKeyword("NUMERIC", 1);
        this.addKeyword("OBJECT", 1);
        this.addKeyword("OF", 1);
        this.addKeyword("OFF", 1);
        this.addKeyword("OLD", 1);
        this.addKeyword("ON", 1);
        this.addKeyword("ONLY", 1);
        this.addKeyword("OPEN", 1);
        this.addKeyword("OPERATION", 1);
        this.addKeyword("OPTION", 1);
        this.addKeyword("OR", 1);
        this.addKeyword("ORDER", 1);
        this.addKeyword("ORDINALITY", 1);
        this.addKeyword("OUT", 1);
        this.addKeyword("OUTER", 1);
        this.addKeyword("OUTPUT", 1);
        this.addKeyword("PAD", 1);
        this.addKeyword("PARAMETER", 1);
        this.addKeyword("PARAMETERS", 1);
        this.addKeyword("PARTIAL", 1);
        this.addKeyword("PATH", 1);
        this.addKeyword("PERIOD", 1);
        this.addKeyword("POSTFIX", 1);
        this.addKeyword("PRECEDES", 1);
        this.addKeyword("PRECISION", 1);
        this.addKeyword("PREFIX", 1);
        this.addKeyword("PREORDER", 1);
        this.addKeyword("PREPARE", 1);
        this.addKeyword("PRESERVE", 1);
        this.addKeyword("PRIMARY", 1);
        this.addKeyword("PRIOR", 1);
        this.addKeyword("PRIVILEGES", 1);
        this.addKeyword("PROCEDURE", 1);
        this.addKeyword("PUBLIC", 1);
        this.addKeyword("READ", 1);
        this.addKeyword("READS", 1);
        this.addKeyword("REAL", 1);
        this.addKeyword("RECURSIVE", 1);
        this.addKeyword("REDO", 1);
        this.addKeyword("REF", 1);
        this.addKeyword("REFRENCES", 1);
        this.addKeyword("REFRENCING", 1);
        this.addKeyword("RELATIVE", 1);
        this.addKeyword("REPEAT", 1);
        this.addKeyword("RESIGNAL", 1);
        this.addKeyword("RESTRICT", 1);
        this.addKeyword("RESULT", 1);
        this.addKeyword("RETURN", 1);
        this.addKeyword("RETURNS", 1);
        this.addKeyword("REVOKE", 1);
        this.addKeyword("RIGHT", 1);
        this.addKeyword("ROLE", 1);
        this.addKeyword("ROLLBACK", 1);
        this.addKeyword("ROLLUP", 1);
        this.addKeyword("ROUTINE", 1);
        this.addKeyword("ROW", 1);
        this.addKeyword("ROWS", 1);
        this.addKeyword("SAVEPOINT", 1);
        this.addKeyword("SCHEMA", 1);
        this.addKeyword("SCROLL", 1);
        this.addKeyword("SEARCH", 1);
        this.addKeyword("SECOND", 1);
        this.addKeyword("SECTION", 1);
        this.addKeyword("SELECT", 1);
        this.addKeyword("SEQUENCE", 1);
        this.addKeyword("SESSION", 1);
        this.addKeyword("SESSION_USER", 1);
        this.addKeyword("SET", 1);
        this.addKeyword("SETS", 1);
        this.addKeyword("SIGNAL", 1);
        this.addKeyword("SIZE", 1);
        this.addKeyword("SMALLINT", 1);
        this.addKeyword("SPECIFIC", 1);
        this.addKeyword("SPECIFICTYPE", 1);
        this.addKeyword("SQL", 1);
        this.addKeyword("SQLEXCEPTION", 1);
        this.addKeyword("SQLSTATE", 1);
        this.addKeyword("SQLWARNING", 1);
        this.addKeyword("START", 1);
        this.addKeyword("STATE", 1);
        this.addKeyword("STATIC", 1);
        this.addKeyword("STRUCTURE", 1);
        this.addKeyword("SUCCEEDS", 1);
        this.addKeyword("SUM", 1);
        this.addKeyword("SYSTEM_USER", 1);
        this.addKeyword("TABLE", 1);
        this.addKeyword("TEMPORARY", 1);
        this.addKeyword("TERMINATE", 1);
        this.addKeyword("THAN", 1);
        this.addKeyword("THEN", 1);
        this.addKeyword("TIME", 1);
        this.addKeyword("TIMESTAMP", 1);
        this.addKeyword("TIMEZONE_HOUR", 1);
        this.addKeyword("TIMEZONE_MINUTE", 1);
        this.addKeyword("TO", 1);
        this.addKeyword("TRAILING", 1);
        this.addKeyword("TRANSACTION", 1);
        this.addKeyword("TRANSLATION", 1);
        this.addKeyword("TREAT", 1);
        this.addKeyword("TRIGGER", 1);
        this.addKeyword("TRUE", 1);
        this.addKeyword("UNDER", 1);
        this.addKeyword("UNDO", 1);
        this.addKeyword("UNION", 1);
        this.addKeyword("UNIQUE", 1);
        this.addKeyword("UNKNOWN", 1);
        this.addKeyword("UNTIL", 1);
        this.addKeyword("UPDATE", 1);
        this.addKeyword("USAGE", 1);
        this.addKeyword("USER", 1);
        this.addKeyword("USING", 1);
        this.addKeyword("VALUE", 1);
        this.addKeyword("VALUES", 1);
        this.addKeyword("VARIABLE", 1);
        this.addKeyword("VARYING", 1);
        this.addKeyword("VIEW", 1);
        this.addKeyword("WHEN", 1);
        this.addKeyword("WHENEVER", 1);
        this.addKeyword("WHERE", 1);
        this.addKeyword("WHILE", 1);
        this.addKeyword("WITH", 1);
        this.addKeyword("WRITE", 1);
        this.addKeyword("YEAR", 1);
        this.addKeyword("ZONE", 1);
        this.addKeyword("MAX", 2);
        this.addKeyword("MIN", 2);
        this.addKeyword("AVG", 2);
        this.addKeyword("COUNT", 2);
    }

    private void initDefaults() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Font font = this.prefs.getFont("editor.font");
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
        StyleConstants.setBold(simpleAttributeSet, font.isBold());
        StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
        StyleConstants.setForeground(simpleAttributeSet, this.prefs.getColor("editor.default-color"));
        StyleConstants.setBackground(simpleAttributeSet, this.prefs.getColor("editor.background-color"));
        this.defaults[0] = simpleAttributeSet;
        this.defaults[1] = this.createSet(simpleAttributeSet, "editor.sql-keywords");
        this.defaults[2] = this.createSet(simpleAttributeSet, "editor.sline-comments");
        this.defaults[5] = this.createSet(simpleAttributeSet, "editor.local-obj");
        this.defaults[6] = this.createSet(simpleAttributeSet, "editor.literals");
        this.defaults[3] = this.createSet(simpleAttributeSet, "editor.multicomment-color");
        this.defaults[4] = this.createSet(simpleAttributeSet, "editor.sline-comments");
        this.defaults[7] = this.createSet(simpleAttributeSet, "editor.parameters");
        this.defaults[8] = this.createSet(simpleAttributeSet, "editor.foreign-obj");
        this.defaults[9] = this.createSet(simpleAttributeSet, "editor.procedures");
        this.defaults[10] = this.createSet(simpleAttributeSet, "editor.tablespace");
        this.prefs.addPreferenceChangeListener(this);
    }

    private SimpleAttributeSet createSet(AttributeSet attributeSet, String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        String string2 = null;
        simpleAttributeSet.setResolveParent(attributeSet);
        string2 = ConfigConstants.createStyleKey(string, "color");
        StyleConstants.setForeground(simpleAttributeSet, this.prefs.getColor(string2));
        string2 = ConfigConstants.createStyleKey(string, "italics");
        StyleConstants.setItalic(simpleAttributeSet, this.prefs.getBoolean(string2));
        string2 = ConfigConstants.createStyleKey(string, "bolded");
        StyleConstants.setBold(simpleAttributeSet, this.prefs.getBoolean(string2));
        return simpleAttributeSet;
    }

    public static class 1 {
    }

    private static class FunctionModel
    extends SuggestionListModel {
        private ArrayList rootStore = new ArrayList();

        private FunctionModel() {
        }

        public int applySuggestion(Object object, Document document, int n2, int n3) throws BadLocationException {
            this.clear();
            if (object == null) {
                return -1;
            }
            String string = object.toString().trim();
            String string2 = BasicUtilities.getCurrentWord(document, n3);
            int n4 = string2.length();
            document.remove(n3 -= n4, n4);
            document.insertString(n3, string, null);
            return n3 + string.length();
        }

        public void updateSuggestion(Document document, int n2) throws BadLocationException {
            String string = BasicUtilities.getCurrentWord(document, n2);
            Iterator iterator = this.rootStore.iterator();
            this.clear();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.indexOf(string) < 0) continue;
                this.addElement(string2);
            }
        }

        public /* synthetic */ FunctionModel(1 var1_1) {
            this();
        }
    }
}

