/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public class SHA2
extends MessageDigestSpi
implements Cloneable {
    private static final int LENGTH = 32;
    private static final int ITERATION = 64;
    private static final int COUNT_MASK = 63;
    private static final int[] ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] W = new int[64];
    private long count = 0L;
    private int AA;
    private int BB;
    private int CC;
    private int DD;
    private int EE;
    private int FF;
    private int GG;
    private int HH;

    protected int engineGetDigestLength() {
        return 32;
    }

    public SHA2() {
        this.init();
    }

    private void computeBlock() {
        int n2;
        for (n2 = 16; n2 < 64; ++n2) {
            this.W[n2] = SHA2.lf_delta1(this.W[n2 - 2]) + this.W[n2 - 7] + SHA2.lf_delta0(this.W[n2 - 15]) + this.W[n2 - 16];
        }
        int n3 = this.AA;
        int n4 = this.BB;
        int n5 = this.CC;
        int n6 = this.DD;
        int n7 = this.EE;
        int n8 = this.FF;
        int n9 = this.GG;
        int n10 = this.HH;
        for (n2 = 0; n2 < 64; ++n2) {
            int n11 = n10 + SHA2.lf_sigma1(n7) + SHA2.lf_ch(n7, n8, n9) + ROUND_CONSTS[n2] + this.W[n2];
            int n12 = SHA2.lf_sigma0(n3) + SHA2.lf_maj(n3, n4, n5);
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6 + n11;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n11 + n12;
        }
        this.AA += n3;
        this.BB += n4;
        this.CC += n5;
        this.DD += n6;
        this.EE += n7;
        this.FF += n8;
        this.GG += n9;
        this.HH += n10;
    }

    protected void engineReset() {
        this.init();
    }

    private void init() {
        this.AA = 1779033703;
        this.BB = -1150833019;
        this.CC = 1013904242;
        this.DD = -1521486534;
        this.EE = 1359893119;
        this.FF = -1694144372;
        this.GG = 528734635;
        this.HH = 1541459225;
        for (int i2 = 0; i2 < 64; ++i2) {
            this.W[i2] = 0;
        }
        this.count = 0L;
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[32];
        try {
            int n2 = this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw new InternalError("");
        }
        return byArray;
    }

    protected void engineUpdate(byte by2) {
        this.update(by2);
    }

    private static int lf_delta0(int n2) {
        return SHA2.lf_S(n2, 7) ^ SHA2.lf_S(n2, 18) ^ SHA2.lf_R(n2, 3);
    }

    private static int lf_delta1(int n2) {
        return SHA2.lf_S(n2, 17) ^ SHA2.lf_S(n2, 19) ^ SHA2.lf_R(n2, 10);
    }

    private static int lf_sigma0(int n2) {
        return SHA2.lf_S(n2, 2) ^ SHA2.lf_S(n2, 13) ^ SHA2.lf_S(n2, 22);
    }

    private static int lf_sigma1(int n2) {
        return SHA2.lf_S(n2, 6) ^ SHA2.lf_S(n2, 11) ^ SHA2.lf_S(n2, 25);
    }

    private void update(int n2) {
        int n3 = ((int)this.count & 0x3F) >>> 2;
        int n4 = (~((int)this.count) & 3) << 3;
        this.W[n3] = this.W[n3] & ~(255 << n4) | (n2 & 0xFF) << n4;
        if (((int)this.count & 0x3F) == 63) {
            this.computeBlock();
        }
        ++this.count;
    }

    private static int lf_R(int n2, int n3) {
        return n2 >>> n3;
    }

    private static int lf_S(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private static int lf_ch(int n2, int n3, int n4) {
        return n2 & n3 ^ ~n2 & n4;
    }

    private static int lf_maj(int n2, int n3, int n4) {
        return n2 & n3 ^ n2 & n4 ^ n3 & n4;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < 32) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < 32) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        long l2 = this.count << 3;
        this.update(128);
        while ((int)(this.count & 0x3FL) != 56) {
            this.update(0);
        }
        this.W[14] = (int)(l2 >>> 32);
        this.W[15] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        this.count += 8L;
        this.computeBlock();
        byArray[n2 + 0] = (byte)(this.AA >>> 24);
        byArray[n2 + 1] = (byte)(this.AA >>> 16);
        byArray[n2 + 2] = (byte)(this.AA >>> 8);
        byArray[n2 + 3] = (byte)(this.AA >>> 0);
        byArray[n2 + 4] = (byte)(this.BB >>> 24);
        byArray[n2 + 5] = (byte)(this.BB >>> 16);
        byArray[n2 + 6] = (byte)(this.BB >>> 8);
        byArray[n2 + 7] = (byte)(this.BB >>> 0);
        byArray[n2 + 8] = (byte)(this.CC >>> 24);
        byArray[n2 + 9] = (byte)(this.CC >>> 16);
        byArray[n2 + 10] = (byte)(this.CC >>> 8);
        byArray[n2 + 11] = (byte)(this.CC >>> 0);
        byArray[n2 + 12] = (byte)(this.DD >>> 24);
        byArray[n2 + 13] = (byte)(this.DD >>> 16);
        byArray[n2 + 14] = (byte)(this.DD >>> 8);
        byArray[n2 + 15] = (byte)(this.DD >>> 0);
        byArray[n2 + 16] = (byte)(this.EE >>> 24);
        byArray[n2 + 17] = (byte)(this.EE >>> 16);
        byArray[n2 + 18] = (byte)(this.EE >>> 8);
        byArray[n2 + 19] = (byte)(this.EE >>> 0);
        byArray[n2 + 20] = (byte)(this.FF >>> 24);
        byArray[n2 + 21] = (byte)(this.FF >>> 16);
        byArray[n2 + 22] = (byte)(this.FF >>> 8);
        byArray[n2 + 23] = (byte)(this.FF >>> 0);
        byArray[n2 + 24] = (byte)(this.GG >>> 24);
        byArray[n2 + 25] = (byte)(this.GG >>> 16);
        byArray[n2 + 26] = (byte)(this.GG >>> 8);
        byArray[n2 + 27] = (byte)(this.GG >>> 0);
        byArray[n2 + 28] = (byte)(this.HH >>> 24);
        byArray[n2 + 29] = (byte)(this.HH >>> 16);
        byArray[n2 + 30] = (byte)(this.HH >>> 8);
        byArray[n2 + 31] = (byte)(this.HH >>> 0);
        this.engineReset();
        return 32;
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (n3 > 0 && ((int)this.count & 3) != 0) {
            this.engineUpdate(byArray[n2]);
            ++n2;
            --n3;
        }
        while (n3 >= 4) {
            int n4 = ((int)this.count & 0x3F) >> 2;
            this.W[n4] = (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
            this.count += 4L;
            if (((int)this.count & 0x3F) == 0) {
                this.computeBlock();
            }
            n3 -= 4;
            n2 += 4;
        }
        while (n3 > 0) {
            this.engineUpdate(byArray[n2++]);
            --n3;
        }
    }

    public Object clone() {
        SHA2 sHA2 = null;
        sHA2 = new SHA2(this);
        return sHA2;
    }

    private SHA2(SHA2 sHA2) {
        this();
        System.arraycopy(sHA2.W, 0, this.W, 0, this.W.length);
        this.count = sHA2.count;
        this.AA = sHA2.AA;
        this.BB = sHA2.BB;
        this.CC = sHA2.CC;
        this.DD = sHA2.DD;
        this.EE = sHA2.EE;
        this.FF = sHA2.FF;
        this.GG = sHA2.GG;
        this.HH = sHA2.HH;
    }
}

