/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.swt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class SWTUtils {
    private static final String Az = "ABCpqr";
    protected static final JPanel DUMMY_PANEL = new JPanel();

    public static FontData toSwtFontData(Device device, Font font, boolean ensureSameSize) {
        FontData fontData = new FontData();
        fontData.setName(font.getFamily());
        fontData.setStyle(font.getStyle());
        int height = (int)Math.round((double)font.getSize() * 72.0 / (double)device.getDPI().y);
        fontData.setHeight(height);
        if (ensureSameSize) {
            GC tmpGC = new GC((Drawable)device);
            org.eclipse.swt.graphics.Font tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
            tmpGC.setFont(tmpFont);
            if (tmpGC.textExtent((String)Az).x > DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                while (tmpGC.textExtent((String)Az).x > DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                    tmpFont.dispose();
                    fontData.setHeight(--height);
                    tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
                    tmpGC.setFont(tmpFont);
                }
            } else if (tmpGC.textExtent((String)Az).x < DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                while (tmpGC.textExtent((String)Az).x < DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                    tmpFont.dispose();
                    fontData.setHeight(++height);
                    tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
                    tmpGC.setFont(tmpFont);
                }
            }
            tmpFont.dispose();
            tmpGC.dispose();
        }
        return fontData;
    }

    public static Font toAwtFont(Device device, FontData fontData, boolean ensureSameSize) {
        int height = (int)Math.round((double)(fontData.getHeight() * device.getDPI().y) / 72.0);
        if (ensureSameSize) {
            GC tmpGC = new GC((Drawable)device);
            org.eclipse.swt.graphics.Font tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
            tmpGC.setFont(tmpFont);
            JPanel DUMMY_PANEL = new JPanel();
            Font tmpAwtFont = new Font(fontData.getName(), fontData.getStyle(), height);
            if (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) > tmpGC.textExtent((String)Az).x) {
                while (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) > tmpGC.textExtent((String)Az).x) {
                    tmpAwtFont = new Font(fontData.getName(), fontData.getStyle(), --height);
                }
            } else if (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) < tmpGC.textExtent((String)Az).x) {
                while (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) < tmpGC.textExtent((String)Az).x) {
                    tmpAwtFont = new Font(fontData.getName(), fontData.getStyle(), ++height);
                }
            }
            tmpFont.dispose();
            tmpGC.dispose();
        }
        return new Font(fontData.getName(), fontData.getStyle(), height);
    }

    public static Font toAwtFont(Device device, org.eclipse.swt.graphics.Font font) {
        FontData fontData = font.getFontData()[0];
        return SWTUtils.toAwtFont(device, fontData, true);
    }

    public static java.awt.Color toAwtColor(Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color toSwtColor(Device device, Paint paint) {
        java.awt.Color color;
        if (paint instanceof java.awt.Color) {
            color = (java.awt.Color)paint;
        } else {
            try {
                throw new Exception("only color is supported at present... setting paint to uniform black color");
            }
            catch (Exception e) {
                e.printStackTrace();
                color = new java.awt.Color(0, 0, 0);
            }
        }
        return new Color(device, color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color toSwtColor(Device device, java.awt.Color color) {
        return new Color(device, color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Rectangle toSwtRectangle(Rectangle2D rect2d) {
        return new Rectangle((int)Math.round(rect2d.getMinX()), (int)Math.round(rect2d.getMinY()), (int)Math.round(rect2d.getWidth()), (int)Math.round(rect2d.getHeight()));
    }

    public static Rectangle2D toAwtRectangle(Rectangle rect) {
        Rectangle2D.Double rect2d = new Rectangle2D.Double();
        ((Rectangle2D)rect2d).setRect(rect.x, rect.y, rect.width, rect.height);
        return rect2d;
    }

    public static Point2D toAwtPoint(Point p) {
        return new java.awt.Point(p.x, p.y);
    }

    public static Point toSwtPoint(java.awt.Point p) {
        return new Point(p.x, p.y);
    }

    public static Point toSwtPoint(Point2D p) {
        return new Point((int)Math.round(p.getX()), (int)Math.round(p.getY()));
    }

    public static MouseEvent toAwtMouseEvent(org.eclipse.swt.events.MouseEvent event) {
        int button = 0;
        switch (event.button) {
            case 1: {
                button = 1;
                break;
            }
            case 2: {
                button = 2;
                break;
            }
            case 3: {
                button = 3;
            }
        }
        int modifiers = 0;
        if ((event.stateMask & 0x40000) != 0) {
            modifiers |= 0x80;
        }
        if ((event.stateMask & 0x20000) != 0) {
            modifiers |= 0x40;
        }
        if ((event.stateMask & 0x10000) != 0) {
            modifiers |= 0x200;
        }
        MouseEvent awtMouseEvent = new MouseEvent(DUMMY_PANEL, event.hashCode(), event.time, modifiers, event.x, event.y, 1, false, button);
        return awtMouseEvent;
    }

    public static ImageData convertAWTImageToSWT(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w == -1 || h == -1) {
            return null;
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return SWTUtils.convertToSWT(bi);
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                }
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            for (int i = 0; i < rgbs.length; ++i) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                }
            }
            return data;
        }
        return null;
    }
}

