#FindTNCS.cmake
#
# Created on: 25.02.2010
#     Author: Alexander Schulz
#

FIND_PATH(Tncvpn_INCLUDE_DIR NAMES tncvpn PATH_SUFFIXES src)

FIND_LIBRARY(Tncvpn_LIBRARY tncvpn)

IF(Tncvpn_INCLUDE_DIR)
    IF(EXISTS "${Tncvpn_INCLUDE_DIR}/tncvpn/version.h")
        FILE(READ "${Tncvpn_INCLUDE_DIR}/tncvpn/version.h" _tncs_VERSION_H_CONTENTS)
    
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION_MAJOR *([0-9]+).*" "\\1" Tncvpn_VERSION_MAJOR "${_tncvpn_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION_MINOR *([0-9]+).*" "\\1" Tncvpn_VERSION_MINOR "${_tncvpn_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION_PATCH *([0-9]+).*" "\\1" Tncvpn_VERSION_PATCH "${_tncvpn_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION_TWEAK *([0-9]+).*" "\\1" Tncvpn_VERSION_TWEAK "${_tncvpn_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION_SUPPLEMENT *\"([^\"]*)\".*" "\\1" Tncvpn_VERSION_SUPPLEMENT "${_tncvpn_VERSION_H_CONTENTS}")
    
        STRING(REGEX REPLACE ".*#define TNCVPN_VERSION \"([^\"]+)\".*" "\\1" Tncvpn_VERSION "${_tncvpn_VERSION_H_CONTENTS}")
    ELSE()
        INCLUDE("${Tncvpn_INCLUDE_DIR}/../tncvpnVersion.cmake")
        LIST(APPEND Tncvpn_INCLUDE_DIRS "${Tncvpn_INCLUDE_DIR}/../include")
        GET_FILENAME_COMPONENT(TMP_Tncvpn_LIBRARY_DIR "${Tncvpn_LIBRARY}" PATH)
        LIST(APPEND Tncvpn_INCLUDE_DIRS "${TMP_Tncvpn_LIBRARY_DIR}")
        
        SET(Tncvpn_VERSION "${Tncvpn_VERSION_MAJOR}.${Tncvpn_VERSION_MINOR}.${Tncvpn_VERSION_PATCH}")
        IF (Tncvpn_VERSION_TWEAK)
            SET(Tncvpn_VERSION "${Tncvpn_VERSION}.${Tncvpn_VERSION_TWEAK}")
        ENDIF (Tncvpn_VERSION_TWEAK)
        IF (Tncvpn_VERSION_SUPPLEMENT)
            SET(Tncvpn_VERSION "${Tncvpn_VERSION}-${Tncvpn_VERSION_SUPPLEMENT}")
        ENDIF (Tncvpn_VERSION_SUPPLEMENT)
    ENDIF()
ENDIF()

IF (Tncvpn_INCLUDE_DIR AND Tncvpn_LIBRARY)
   SET(Tncvpn_FOUND TRUE)
ENDIF (Tncvpn_INCLUDE_DIR AND Tncvpn_LIBRARY)

IF(Tncvpn_FOUND)
    IF(Tncvpn_FIND_VERSION_MAJOR AND NOT Tncvpn_FIND_VERSION_MAJOR EQUAL "${Tncvpn_VERSION_MAJOR}")
        IF(Tncvpn_FIND_VERSION_EXACT OR Tncvpn_FIND_VERSION_MAJOR GREATER "${Tncvpn_VERSION_MAJOR}")
            SET(Tncvpn_FOUND FALSE)
        ENDIF()
    ELSE()
        IF(Tncvpn_FIND_VERSION_MINOR AND NOT Tncvpn_FIND_VERSION_MINOR EQUAL "${Tncvpn_VERSION_MINOR}")
            IF(Tncvpn_FIND_VERSION_EXACT OR Tncvpn_FIND_VERSION_MINOR GREATER "${Tncvpn_VERSION_MINOR}")
                SET(Tncvpn_FOUND FALSE)
            ENDIF()
        ELSE()
            IF(Tncvpn_FIND_VERSION_PATCH AND NOT Tncvpn_FIND_VERSION_PATCH EQUAL "${Tncvpn_VERSION_PATCH}")
                IF(Tncvpn_FIND_VERSION_EXACT OR Tncvpn_FIND_VERSION_PATCH GREATER "${Tncvpn_VERSION_PATCH}")
                    SET(Tncvpn_FOUND FALSE)
                ENDIF()
            ELSE()
                IF(Tncvpn_FIND_VERSION_TWEAK AND NOT Tncvpn_FIND_VERSION_TWEAK EQUAL "${Tncvpn_VERSION_TWEAK}")
                    IF(Tncvpn_FIND_VERSION_EXACT OR Tncvpn_FIND_VERSION_TWEAK GREATER "${Tncvpn_VERSION_TWEAK}")
                        SET(Tncvpn_FOUND FALSE)
                    ENDIF()
                ENDIF()
            ENDIF()
        ENDIF()
    ENDIF()
ENDIF(Tncvpn_FOUND)

IF (Tncvpn_FOUND)
    LIST(APPEND Tncvpn_INCLUDE_DIRS "${Tncvpn_INCLUDE_DIR}")
    LIST(APPEND Tncvpn_LIBRARIES "${Tncvpn_LIBRARY}")

   IF (NOT Tncvpn_FIND_QUIETLY)
      MESSAGE(STATUS "Found Tncvpn: ${Tncvpn_LIBRARY} (${Tncvpn_VERSION})")
   ENDIF (NOT Tncvpn_FIND_QUIETLY)
ELSE (Tncvpn_FOUND)
   IF (NOT Tncvpn_INCLUDE_DIR AND NOT Tncvpn_LIBRARY)
       SET(TMP_REASON "Include and Library not found.")
   ELSEIF(Tncvpn_INCLUDE_DIR AND NOT Tncvpn_LIBRARY)
       SET(TMP_REASON "Library not found.")
   ELSEIF(NOT Tncvpn_INCLUDE_DIR AND Tncvpn_LIBRARY)
       SET(TMP_REASON "Include not found.")
   ELSE (NOT Tncvpn_INCLUDE_DIR AND NOT Tncvpn_LIBRARY)
       SET(TMP_REASON "Version ${Tncvpn_FIND_VERSION} not found.")
   ENDIF(NOT Tncvpn_INCLUDE_DIR AND NOT Tncvpn_LIBRARY)

   IF (Tncvpn_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find Tncvpn. Reason: ${TMP_REASON}")
   ELSE (Tncvpn_FIND_REQUIRED)
      MESSAGE(STATUS "Could not find Tncvpn. Reason: ${TMP_REASON}")
   ENDIF (Tncvpn_FIND_REQUIRED)
ENDIF (Tncvpn_FOUND)
