//%LICENSE////////////////////////////////////////////////////////////////
//
// Licensed to The Open Group (TOG) under one or more contributor license
// agreements.  Refer to the OpenPegasusNOTICE.txt file distributed with
// this work for additional information regarding copyright ownership.
// Each contributor licenses this file to you under the OpenPegasus Open
// Source License; you may not use this file except in compliance with the
// License.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//////////////////////////////////////////////////////////////////////////
//
//%/////////////////////////////////////////////////////////////////////////////

#ifndef Pegasus_ProviderManager_h
#define Pegasus_ProviderManager_h

#include <Pegasus/Common/Config.h>
#include <Pegasus/Common/PegasusVersion.h>
#include <Pegasus/Common/CIMMessage.h>

#include <Pegasus/ProviderManager2/Linkage.h>

PEGASUS_NAMESPACE_BEGIN

typedef void (*PEGASUS_INDICATION_CALLBACK_T)(
    CIMProcessIndicationRequestMessage*);

typedef void (*PEGASUS_RESPONSE_CHUNK_CALLBACK_T)(
    CIMRequestMessage* request, CIMResponseMessage* response);

class PEGASUS_PPM_LINKAGE ProviderManager
{
public:
    ProviderManager();
    virtual ~ProviderManager();

    virtual Message* processMessage(Message* message) = 0;

    virtual Boolean hasActiveProviders() = 0;
    virtual void unloadIdleProviders() = 0;
    static String _resolvePhysicalName(String physicalName);

    /**
        Sets the callback function to which indications generated by this
        ProviderManager should be forwarded for processing.
     */
    virtual void setIndicationCallback(
        PEGASUS_INDICATION_CALLBACK_T indicationCallback);

    /**
        Sets the callback function to which response chunks generated by this
        ProviderManager should be forwarded for processing.
     */
    virtual void setResponseChunkCallback(
        PEGASUS_RESPONSE_CHUNK_CALLBACK_T responseChunkCallback);

    virtual Boolean supportsRemoteNameSpaces() { return false; }

    /**
        Sets the SubscriptionInitComplete flag indicating whether the Indication
        Service has completed its initialization.
     */
    virtual void setSubscriptionInitComplete(Boolean subscriptionInitComplete);

protected:
    PEGASUS_INDICATION_CALLBACK_T _indicationCallback;
    PEGASUS_RESPONSE_CHUNK_CALLBACK_T _responseChunkCallback;

    /**
        Indicates whether the Indication Service has completed initialization.

        For more information, please see the description of the
        ProviderManagerRouter::_subscriptionInitComplete member variable.
     */
    Boolean _subscriptionInitComplete;

    // ingredients for CIMOMHandle (binary message handler, repository, etc.)
};

PEGASUS_NAMESPACE_END

#define PEGASUS_GET_VERSION_FUNC \
extern "C" PEGASUS_EXPORT Uint32 getPegasusVersion() \
{ \
    return PEGASUS_VERSION_NUMBER;  \
}

#endif
