//%LICENSE////////////////////////////////////////////////////////////////
//
// Licensed to The Open Group (TOG) under one or more contributor license
// agreements.  Refer to the OpenPegasusNOTICE.txt file distributed with
// this work for additional information regarding copyright ownership.
// Each contributor licenses this file to you under the OpenPegasus Open
// Source License; you may not use this file except in compliance with the
// License.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//////////////////////////////////////////////////////////////////////////
//
//%////////////////////////////////////////////////////////////////////////////


#ifndef ShutdownProvider_h
#define ShutdownProvider_h

///////////////////////////////////////////////////////////////////////////////
//  Shutdown Provider
///////////////////////////////////////////////////////////////////////////////

#include <Pegasus/Common/Config.h>
#include <Pegasus/Common/Tracer.h>

#include <Pegasus/Provider/CIMMethodProvider.h>
#include <Pegasus/Server/ShutdownService.h>
#include <Pegasus/Server/Linkage.h>

PEGASUS_NAMESPACE_BEGIN

/**
    The ShutdownProvider is a method provider that implements the shutdown
    method in the PG_ShutdownService class.  It provides response to the
    shutdown request from clients to shutdown cimom gracefully.
*/
class PEGASUS_SERVER_LINKAGE ShutdownProvider : public CIMMethodProvider
{
public:

    /** Constructor */
    ShutdownProvider(CIMServer* cimserver)
    {
        PEG_METHOD_ENTER(TRC_SHUTDOWN, "ShutdownProvider::ShutdownProvider");

        //
        // get an instance of the Shutdown Service
        //
        _shutdownService = ShutdownService::getInstance(cimserver);

        PEG_METHOD_EXIT();
    }

    /** Destructor */
    virtual ~ShutdownProvider()
    {
        PEG_METHOD_ENTER(TRC_SHUTDOWN,"ShutdownProvider::~ShutdownProvider");
        PEG_METHOD_EXIT();
    }

    // Note:  The initialize() and terminate() methods are not called for
    // Control Providers.
    void initialize(CIMOMHandle& cimomHandle) { }
    void terminate() { }

    /**
        Invoke Method.  Used to shutdown cimom.
    */
    void invokeMethod(
        const OperationContext& context,
        const CIMObjectPath& objectReference,
        const CIMName& methodName,
        const Array<CIMParamValue>& inParameters,
        MethodResultResponseHandler& handler);

private:

    //
    // Shutdown Service Instance variable
    //
    ShutdownService* _shutdownService;
};

PEGASUS_NAMESPACE_END

#endif  // ShutdownProvider_h
