//%LICENSE////////////////////////////////////////////////////////////////
//
// Licensed to The Open Group (TOG) under one or more contributor license
// agreements.  Refer to the OpenPegasusNOTICE.txt file distributed with
// this work for additional information regarding copyright ownership.
// Each contributor licenses this file to you under the OpenPegasus Open
// Source License; you may not use this file except in compliance with the
// License.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//////////////////////////////////////////////////////////////////////////
//
//%////////////////////////////////////////////////////////////////////////////

#ifndef _CmpiBooleanData_h_
#define _CmpiBooleanData_h_

#include "CmpiData.h"
#include "Linkage.h"

/**
    This class wraps a CMPIBooleanData value item. BooleanData extraction uses
    type operators. Extraction operations can be appended to a
    property type retrieval statement
      like this:

    CmpiString name = cop.getKey("DeviceID");

    Type mismatches will be signalled by exceptions.
*/
class PEGASUS_CMPI_PROVIDER_LINKAGE CmpiBooleanData : public CmpiData
{
public:

    /**
        Constructor - boolean as input.
    */
    CmpiBooleanData(CMPIBoolean d);

};

extern PEGASUS_CMPI_PROVIDER_LINKAGE CmpiBooleanData CmpiTrue;
extern PEGASUS_CMPI_PROVIDER_LINKAGE CmpiBooleanData CmpiFalse;

#endif
