/*
*         OpenPBS (Portable Batch System) v2.3 Software License
*
* Copyright (c) 1999-2000 Veridian Information Solutions, Inc.
* All rights reserved.
*
* ---------------------------------------------------------------------------
* For a license to use or redistribute the OpenPBS software under conditions
* other than those described below, or to purchase support for this software,
* please contact Veridian Systems, PBS Products Department ("Licensor") at:
*
*    www.OpenPBS.org  +1 650 967-4675                  sales@OpenPBS.org
*                        877 902-4PBS (US toll-free)
* ---------------------------------------------------------------------------
*
* This license covers use of the OpenPBS v2.3 software (the "Software") at
* your site or location, and, for certain users, redistribution of the
* Software to other sites and locations.  Use and redistribution of
* OpenPBS v2.3 in source and binary forms, with or without modification,
* are permitted provided that all of the following conditions are met.
* After December 31, 2001, only conditions 3-6 must be met:
*
* 1. Commercial and/or non-commercial use of the Software is permitted
*    provided a current software registration is on file at www.OpenPBS.org.
*    If use of this software contributes to a publication, product, or
*    service, proper attribution must be given; see www.OpenPBS.org/credit.html
*
* 2. Redistribution in any form is only permitted for non-commercial,
*    non-profit purposes.  There can be no charge for the Software or any
*    software incorporating the Software.  Further, there can be no
*    expectation of revenue generated as a consequence of redistributing
*    the Software.
*
* 3. Any Redistribution of source code must retain the above copyright notice
*    and the acknowledgment contained in paragraph 6, this list of conditions
*    and the disclaimer contained in paragraph 7.
*
* 4. Any Redistribution in binary form must reproduce the above copyright
*    notice and the acknowledgment contained in paragraph 6, this list of
*    conditions and the disclaimer contained in paragraph 7 in the
*    documentation and/or other materials provided with the distribution.
*
* 5. Redistributions in any form must be accompanied by information on how to
*    obtain complete source code for the OpenPBS software and any
*    modifications and/or additions to the OpenPBS software.  The source code
*    must either be included in the distribution or be available for no more
*    than the cost of distribution plus a nominal fee, and all modifications
*    and additions to the Software must be freely redistributable by any party
*    (including Licensor) without restriction.
*
* 6. All advertising materials mentioning features or use of the Software must
*    display the following acknowledgment:
*
*     "This product includes software developed by NASA Ames Research Center,
*     Lawrence Livermore National Laboratory, and Veridian Information
*     Solutions, Inc.
*     Visit www.OpenPBS.org for OpenPBS software support,
*     products, and information."
*
* 7. DISCLAIMER OF WARRANTY
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT
* ARE EXPRESSLY DISCLAIMED.
*
* IN NO EVENT SHALL VERIDIAN CORPORATION, ITS AFFILIATED COMPANIES, OR THE
* U.S. GOVERNMENT OR ANY OF ITS AGENCIES BE LIABLE FOR ANY DIRECT OR INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/




/*
 * add_verify_resources
 *
 * Append a entries to the attribute list that are from the resource list.
 * If the add flag is set, append the resource regardless. Otherwise, append
 * it only if it is not already on the list.
 *
 */

#include <pbs_config.h>   /* the master config generated by configure */

#define TRUE 1
#define FALSE 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "pbs_ifl.h"
#include "pbs_cmds.h"
#include "u_hash_map_structs.h"
#include "u_memmgr.h"

/*template: paramname=["]VAL[num-num,num],paramname=["]*/
/* input:*/
/* hostlist=name[1,2],mppnodes=name[1-2],param=\"val1,val2[3-5]\"*/
/* result:*/
/* hostlist=name1+name2,mppnodes=name1+name2,param=val1+val23+val24+val25*/

int add_verify_resources(

  memmgr        **mm,       /* M */
  job_data      **res_attr, /* M */
  char           *resources, /* I */
  int             p_type)    /* I */

  {
  char *r;
  char *eq;
  char *v;
  char *e = NULL;
  char *str;
  char *name;
  char *value = NULL;
  int   gpugres;

  int   len;
  int   vlen;

  char *qptr = NULL;
  int braces = 0;
  r = resources;

  while (*r != '\0')
    {
    /* skip leading whitespace */

    while (isspace((int)*r))
      r++;

    /* get resource name */

    eq = r;

    while ((*eq != '=') && (*eq != ',') && (*eq != '\0'))
      eq++;

    /* make sure there is a resource name */

    if (r == eq)
      {
      /* FAILURE */

      return(1);
      }

    /*
     * Count the number of non-space characters that make up the
     * resource name.  Count only up to the last character before the
     * separator ('\0', ',' or '=').
     */

    for (str = r, len = 0;(str < eq) && !isspace((int)*str);str++)
      len++;

    /* if separated by an equal sign, get the value */

    if (*eq == '=')
      {
      char *ptr;

      v = eq + 1;

      while (isspace((int)*v))
        v++;

      /* FORMAT: <ATTR>=[{'"}]<VAL>,<VAL>[{'"}][,<ATTR>=...]... */

      ptr = strchr(v, ',');

      if (((qptr = strchr(v, '\'')) != NULL) &&
          ((ptr == NULL) || ((ptr != NULL) && (qptr < ptr))))
        { /* skip quote if before ',' or at the end of the string */
        v = qptr + 1;
        }
      else if (((qptr = strchr(v, '\"')) != NULL) && 
               ((ptr == NULL) || ((ptr != NULL) && (qptr < ptr))))
        { /* skip quote if before ',' or at the end of the string */
        v = qptr + 1;
        }
      else
        {
        qptr = NULL;
        }

      e = v;

      while (*e != '\0')
        {
        /* FORMAT: <ATTR>=[{'"}]<VAL>,<VAL>[{'"}][,<ATTR>=...]... */

        /* NOTE    already tokenized by getopt() which will support
                   quoted whitespace, do not fail on spaces */
        if (*e=='[' && qptr == NULL)
          {
          braces = 1;
          }
        if (braces && (*e == ']'))
          {
          braces=0;
          }
        if (qptr != NULL)
          {
          /* value contains quote - only terminate with quote */

          if ((*e == '\'') || (*e == '\"'))
            break;
          }
        else
          {
          if (*e == ',' && braces==0)
            break;
          }

#ifdef TNOT
        if (isspace((int)*e))
          {
          /* FAILURE */

          return(1);
          }

#endif /* TNOT */

        e++;
        }  /* END while (*e != '\0') */
      }    /* END if (*eq == '=') */
    else
      {
      /* no attr=value pair found */
      fprintf(stderr, "Cannot find an attr=value pair in comma separated value '%s'\n", r);
      exit(1);
      }

    /* This code in combination with the backend server code ends up with
     * the logic of last added element remains. All others are dropped off.
     * Instead of posponing all of this logic, it will now occur here.
     */

    gpugres = !strncmp(r,"gpus",strlen("gpus"));
    if (gpugres)
      {
      len = 5;
      /* + 6 = 1 for null terminator and 5 for 'gpus:' */
      vlen = (e - v) + 6; 

      name = (char *)memmgr_calloc(mm, 1, len);
      if (v)
        value = (char *)memmgr_calloc(mm, 1, vlen);
      }
    else
      {
      len++;
      vlen = (e - v) + 1;

      name = (char *)memmgr_calloc(mm, 1, len);
      if (v)
        value = (char *)memmgr_calloc(mm, 1, vlen);
      }

    if ((name) && ((v) && (value)))
      {
      if (gpugres)
        snprintf(name, len, "gres");
      else
        snprintf(name, len, "%s", r);

      if (v)
        {
        if (gpugres)
          {
          char *gpu_eq = strchr(r, '=');

          if(gpu_eq == NULL)
            {
            fprintf(stderr,"Error with resource strings.\n");
            exit(1);
            }
          *gpu_eq = ':';
          snprintf(value, vlen, "%s", r);
          *gpu_eq = '=';
          }
        else
          snprintf(value, vlen, "%s", v);

        hash_add_or_exit(mm, res_attr, name, value, p_type);
        }
      else
        hash_add_or_exit(mm, res_attr, name, (char *)"\0", p_type);
      }
    else
      {
      fprintf(stderr, "Error allocating memory for add_verify_resources\n");
      exit(1);
      }

    /* Get ready for next resource/value pair */

    if (qptr != NULL)
      {
      /* skip quotes looking for ',' */

      while ((*e == '\'') || (*e == '\"'))
        e++;
      }

    if (v != NULL)
      r = e;
    else
      r = eq;

    if (*r == ',')
      {
      r++;

      if (*r == '\0')
        {
        return(1);
        }
      }
    }      /* END while (*r != '\0') */

  /* SUCCESS */

  return(0);
  }  /* END add_verify_resources() */

