% tpm2_certifycreation(1) tpm2-tools | General Commands Manual

# NAME

**tpm2_certifycreation**(1) - Attest the association between a loaded public
area and the provided hash of the creation data.

# SYNOPSIS

**tpm2_certifycreation** [*OPTIONS*]

# DESCRIPTION

**tpm2_certifycreation**(1) - Attest the association between a loaded public
area and the provided hash of the creation data. The creation data and the
creation ticket is produced when creating the object. The object itself is
created with either **TPM2_CreatePrimary** or **TPM2_Create** commands.

# OPTIONS

  * **-C**, **\--signingkey-context**=_OBJECT_:

    Context object pointing to the key used that signs the attestation.

  * **-P**, **\--signingkey-auth**_AUTH_:

    Optional authorization value to use for the key specified by **-C**.

  * **-c**, **\--certifiedkey-context**=_OBJECT_:

    Context object pointing to the key that has to be certified.

  * **-g**, **\--hash-algorithm**=_ALGORITHM_:

    The hash algorithm used to digest the creation data.

  * **-s**, **\--scheme**=_ALGORITHM_:

    The signing scheme used to sign the attestation data.

  * **-d**, **\--creation-hash**=_FILE_

    File containing the digest of the creation data.

  * **-t**, **\--ticket**=_FILE_:

    The ticket file to validate that the creation data was produced by the TPM.

  * **-o**, **\--signature**=_FILE_:

    File containing the signature of the attestation data for the certified key.

  * **-f**, **\--format**=_FORMAT_:

    Output signature format selection.

  * **--attestation**=_FILE_:

    The attestation data of the type TPM2_CREATION_INFO signed with signing key.

  * **-q**, **\--qualification**=_FILE\_OR\_HEX_:

    Optional, the policy qualifier data that the signer can choose to include in the
    signature. Can either be a path or hex string.

## References

[context object format](common/ctxobj.md) details the methods for specifying
_OBJECT_.

[authorization formatting](common/authorizations.md) details the methods for
specifying _AUTH_.

[algorithm specifiers](common/alg.md) details the options for specifying
cryptographic algorithms _ALGORITHM_.

[common options](common/options.md) collection of common options that provide
information many users may expect.

[common tcti options](common/tcti.md) collection of options used to configure
the various known TCTI modules.
[signature format specifiers](common/signature.md)

# EXAMPLES

## Certify creation data of a primary key.

```bash
tpm2_createprimary -C o -c prim.ctx --creation-data create.dat \
-d create.dig -t create.ticket

tpm2_create -G rsa -u rsa.pub -r rsa.priv -C prim.ctx -c signing_key.ctx

tpm2_certifycreation -C signing_key.ctx -c prim.ctx -d create.dig \
-t create.ticket -g sha256 -o sig.nature --attestation attestat.ion -f plain \
-s rsassa
```

[returns](common/returns.md)

[footer](common/footer.md)
