/*
 * Copyright (C) Mellanox Technologies Ltd. 2019. ALL RIGHTS RESERVED.
 * See file LICENSE for terms.
 */

#include "org_ucx_jucx_ucp_UcpConstants.h"
#include "jucx_common_def.h"

#include <ucp/api/ucp.h>


/**
 * @brief Routine to set UCX constants in java
 *
 */
JNIEXPORT void JNICALL
Java_org_ucx_jucx_ucp_UcpConstants_loadConstants(JNIEnv *env, jclass cls)
{
    // UCP context parameters
    JUCX_DEFINE_LONG_CONSTANT(UCP_PARAM_FIELD_FEATURES);
    JUCX_DEFINE_LONG_CONSTANT(UCP_PARAM_FIELD_FEATURES);
    JUCX_DEFINE_LONG_CONSTANT(UCP_PARAM_FIELD_TAG_SENDER_MASK);
    JUCX_DEFINE_LONG_CONSTANT(UCP_PARAM_FIELD_MT_WORKERS_SHARED);
    JUCX_DEFINE_LONG_CONSTANT(UCP_PARAM_FIELD_ESTIMATED_NUM_EPS);

    // UCP configuration features
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_TAG);
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_RMA);
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_AMO32);
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_AMO64);
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_WAKEUP);
    JUCX_DEFINE_LONG_CONSTANT(UCP_FEATURE_STREAM);

    // UCP worker parameters.
    JUCX_DEFINE_LONG_CONSTANT(UCP_WORKER_PARAM_FIELD_THREAD_MODE);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WORKER_PARAM_FIELD_CPU_MASK);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WORKER_PARAM_FIELD_EVENTS);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WORKER_PARAM_FIELD_USER_DATA);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WORKER_PARAM_FIELD_EVENT_FD);

    // UCP worker wakeup events
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_RMA);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_AMO);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_TAG_SEND);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_TAG_RECV);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_TX);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_RX);
    JUCX_DEFINE_LONG_CONSTANT(UCP_WAKEUP_EDGE);
}
