/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.ant.RepositoryPolicy;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Repository;

public abstract class AbstractArtifactWithRepositoryTask
extends AbstractArtifactTask {
    private List remoteRepositories = new ArrayList();

    private static RemoteRepository getDefaultRemoteRepository() {
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setId("central");
        remoteRepository.setUrl("http://repo1.maven.org/maven2");
        RepositoryPolicy snapshots = new RepositoryPolicy();
        snapshots.setEnabled(false);
        remoteRepository.addSnapshots(snapshots);
        return remoteRepository;
    }

    private static String statusAsString(RepositoryPolicy policy) {
        return policy == null || policy.isEnabled() ? "enabled" : "disabled";
    }

    protected List createRemoteArtifactRepositories() {
        return this.createRemoteArtifactRepositories(null);
    }

    protected List createRemoteArtifactRepositories(List pomRepositories) {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        remoteRepositories.addAll(this.getRemoteRepositories());
        if (this.getRemoteRepositories().isEmpty()) {
            remoteRepositories.add(AbstractArtifactWithRepositoryTask.getDefaultRemoteRepository());
        }
        if (pomRepositories != null) {
            Iterator i = pomRepositories.iterator();
            while (i.hasNext()) {
                Repository pomRepository = (Repository)i.next();
                remoteRepositories.add(this.createAntRemoteRepository(pomRepository));
            }
        }
        this.log("Using remote repositories:", 3);
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            RemoteRepository remoteRepository = (RemoteRepository)((Object)i.next());
            this.updateRepositoryWithSettings(remoteRepository);
            StringBuffer msg = new StringBuffer();
            msg.append("  - id=" + remoteRepository.getId());
            msg.append(", url=" + remoteRepository.getUrl());
            msg.append(", releases=" + AbstractArtifactWithRepositoryTask.statusAsString(remoteRepository.getReleases()));
            msg.append(", snapshots=" + AbstractArtifactWithRepositoryTask.statusAsString(remoteRepository.getSnapshots()));
            if (remoteRepository.getAuthentication() != null) {
                msg.append(", authentication=" + remoteRepository.getAuthentication().getUserName());
            }
            if (remoteRepository.getProxy() != null) {
                msg.append(", proxy=" + remoteRepository.getProxy().getHost());
            }
            this.getProject().log(msg.toString(), 3);
            list.add(this.createRemoteArtifactRepository(remoteRepository));
        }
        return list;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepositories.add(remoteRepository);
    }
}

