// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See spirv_gramar_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2021 The Khronos Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Spencer Fricke <s.fricke@samsung.com>
 *
 * This file is related to anything that is found in the SPIR-V grammar
 * file found in the SPIRV-Headers. Mainly used for SPIR-V util functions.
 *
 ****************************************************************************/

#pragma once
#include <cstdint>
#include <spirv/unified1/spirv.hpp>

bool AtomicOperation(uint32_t opcode);

bool GroupOperation(uint32_t opcode);

bool ImageGatherOperation(uint32_t opcode);
bool ImageFetchOperation(uint32_t opcode);
bool ImageSampleOperation(uint32_t opcode);

uint32_t MemoryScopeParamPosition(uint32_t opcode);
uint32_t ExecutionScopeParamPosition(uint32_t opcode);
uint32_t ImageOperandsParamPosition(uint32_t opcode);
uint32_t ImageOperandsParamCount(uint32_t opcode);

static inline const char* string_SpvOpcode(uint32_t opcode) {
    switch ((spv::Op)opcode) {
         case spv::OpNop:
            return "OpNop";
         case spv::OpUndef:
            return "OpUndef";
         case spv::OpSourceContinued:
            return "OpSourceContinued";
         case spv::OpSource:
            return "OpSource";
         case spv::OpSourceExtension:
            return "OpSourceExtension";
         case spv::OpName:
            return "OpName";
         case spv::OpMemberName:
            return "OpMemberName";
         case spv::OpString:
            return "OpString";
         case spv::OpLine:
            return "OpLine";
         case spv::OpExtension:
            return "OpExtension";
         case spv::OpExtInstImport:
            return "OpExtInstImport";
         case spv::OpExtInst:
            return "OpExtInst";
         case spv::OpMemoryModel:
            return "OpMemoryModel";
         case spv::OpEntryPoint:
            return "OpEntryPoint";
         case spv::OpExecutionMode:
            return "OpExecutionMode";
         case spv::OpCapability:
            return "OpCapability";
         case spv::OpTypeVoid:
            return "OpTypeVoid";
         case spv::OpTypeBool:
            return "OpTypeBool";
         case spv::OpTypeInt:
            return "OpTypeInt";
         case spv::OpTypeFloat:
            return "OpTypeFloat";
         case spv::OpTypeVector:
            return "OpTypeVector";
         case spv::OpTypeMatrix:
            return "OpTypeMatrix";
         case spv::OpTypeImage:
            return "OpTypeImage";
         case spv::OpTypeSampler:
            return "OpTypeSampler";
         case spv::OpTypeSampledImage:
            return "OpTypeSampledImage";
         case spv::OpTypeArray:
            return "OpTypeArray";
         case spv::OpTypeRuntimeArray:
            return "OpTypeRuntimeArray";
         case spv::OpTypeStruct:
            return "OpTypeStruct";
         case spv::OpTypePointer:
            return "OpTypePointer";
         case spv::OpTypeFunction:
            return "OpTypeFunction";
         case spv::OpTypeForwardPointer:
            return "OpTypeForwardPointer";
         case spv::OpConstantTrue:
            return "OpConstantTrue";
         case spv::OpConstantFalse:
            return "OpConstantFalse";
         case spv::OpConstant:
            return "OpConstant";
         case spv::OpConstantComposite:
            return "OpConstantComposite";
         case spv::OpConstantNull:
            return "OpConstantNull";
         case spv::OpSpecConstantTrue:
            return "OpSpecConstantTrue";
         case spv::OpSpecConstantFalse:
            return "OpSpecConstantFalse";
         case spv::OpSpecConstant:
            return "OpSpecConstant";
         case spv::OpSpecConstantComposite:
            return "OpSpecConstantComposite";
         case spv::OpSpecConstantOp:
            return "OpSpecConstantOp";
         case spv::OpFunction:
            return "OpFunction";
         case spv::OpFunctionParameter:
            return "OpFunctionParameter";
         case spv::OpFunctionEnd:
            return "OpFunctionEnd";
         case spv::OpFunctionCall:
            return "OpFunctionCall";
         case spv::OpVariable:
            return "OpVariable";
         case spv::OpImageTexelPointer:
            return "OpImageTexelPointer";
         case spv::OpLoad:
            return "OpLoad";
         case spv::OpStore:
            return "OpStore";
         case spv::OpCopyMemory:
            return "OpCopyMemory";
         case spv::OpCopyMemorySized:
            return "OpCopyMemorySized";
         case spv::OpAccessChain:
            return "OpAccessChain";
         case spv::OpInBoundsAccessChain:
            return "OpInBoundsAccessChain";
         case spv::OpPtrAccessChain:
            return "OpPtrAccessChain";
         case spv::OpArrayLength:
            return "OpArrayLength";
         case spv::OpInBoundsPtrAccessChain:
            return "OpInBoundsPtrAccessChain";
         case spv::OpDecorate:
            return "OpDecorate";
         case spv::OpMemberDecorate:
            return "OpMemberDecorate";
         case spv::OpDecorationGroup:
            return "OpDecorationGroup";
         case spv::OpGroupDecorate:
            return "OpGroupDecorate";
         case spv::OpGroupMemberDecorate:
            return "OpGroupMemberDecorate";
         case spv::OpVectorExtractDynamic:
            return "OpVectorExtractDynamic";
         case spv::OpVectorInsertDynamic:
            return "OpVectorInsertDynamic";
         case spv::OpVectorShuffle:
            return "OpVectorShuffle";
         case spv::OpCompositeConstruct:
            return "OpCompositeConstruct";
         case spv::OpCompositeExtract:
            return "OpCompositeExtract";
         case spv::OpCompositeInsert:
            return "OpCompositeInsert";
         case spv::OpCopyObject:
            return "OpCopyObject";
         case spv::OpTranspose:
            return "OpTranspose";
         case spv::OpSampledImage:
            return "OpSampledImage";
         case spv::OpImageSampleImplicitLod:
            return "OpImageSampleImplicitLod";
         case spv::OpImageSampleExplicitLod:
            return "OpImageSampleExplicitLod";
         case spv::OpImageSampleDrefImplicitLod:
            return "OpImageSampleDrefImplicitLod";
         case spv::OpImageSampleDrefExplicitLod:
            return "OpImageSampleDrefExplicitLod";
         case spv::OpImageSampleProjImplicitLod:
            return "OpImageSampleProjImplicitLod";
         case spv::OpImageSampleProjExplicitLod:
            return "OpImageSampleProjExplicitLod";
         case spv::OpImageSampleProjDrefImplicitLod:
            return "OpImageSampleProjDrefImplicitLod";
         case spv::OpImageSampleProjDrefExplicitLod:
            return "OpImageSampleProjDrefExplicitLod";
         case spv::OpImageFetch:
            return "OpImageFetch";
         case spv::OpImageGather:
            return "OpImageGather";
         case spv::OpImageDrefGather:
            return "OpImageDrefGather";
         case spv::OpImageRead:
            return "OpImageRead";
         case spv::OpImageWrite:
            return "OpImageWrite";
         case spv::OpImage:
            return "OpImage";
         case spv::OpImageQuerySizeLod:
            return "OpImageQuerySizeLod";
         case spv::OpImageQuerySize:
            return "OpImageQuerySize";
         case spv::OpImageQueryLod:
            return "OpImageQueryLod";
         case spv::OpImageQueryLevels:
            return "OpImageQueryLevels";
         case spv::OpImageQuerySamples:
            return "OpImageQuerySamples";
         case spv::OpConvertFToU:
            return "OpConvertFToU";
         case spv::OpConvertFToS:
            return "OpConvertFToS";
         case spv::OpConvertSToF:
            return "OpConvertSToF";
         case spv::OpConvertUToF:
            return "OpConvertUToF";
         case spv::OpUConvert:
            return "OpUConvert";
         case spv::OpSConvert:
            return "OpSConvert";
         case spv::OpFConvert:
            return "OpFConvert";
         case spv::OpQuantizeToF16:
            return "OpQuantizeToF16";
         case spv::OpConvertPtrToU:
            return "OpConvertPtrToU";
         case spv::OpConvertUToPtr:
            return "OpConvertUToPtr";
         case spv::OpBitcast:
            return "OpBitcast";
         case spv::OpSNegate:
            return "OpSNegate";
         case spv::OpFNegate:
            return "OpFNegate";
         case spv::OpIAdd:
            return "OpIAdd";
         case spv::OpFAdd:
            return "OpFAdd";
         case spv::OpISub:
            return "OpISub";
         case spv::OpFSub:
            return "OpFSub";
         case spv::OpIMul:
            return "OpIMul";
         case spv::OpFMul:
            return "OpFMul";
         case spv::OpUDiv:
            return "OpUDiv";
         case spv::OpSDiv:
            return "OpSDiv";
         case spv::OpFDiv:
            return "OpFDiv";
         case spv::OpUMod:
            return "OpUMod";
         case spv::OpSRem:
            return "OpSRem";
         case spv::OpSMod:
            return "OpSMod";
         case spv::OpFRem:
            return "OpFRem";
         case spv::OpFMod:
            return "OpFMod";
         case spv::OpVectorTimesScalar:
            return "OpVectorTimesScalar";
         case spv::OpMatrixTimesScalar:
            return "OpMatrixTimesScalar";
         case spv::OpVectorTimesMatrix:
            return "OpVectorTimesMatrix";
         case spv::OpMatrixTimesVector:
            return "OpMatrixTimesVector";
         case spv::OpMatrixTimesMatrix:
            return "OpMatrixTimesMatrix";
         case spv::OpOuterProduct:
            return "OpOuterProduct";
         case spv::OpDot:
            return "OpDot";
         case spv::OpIAddCarry:
            return "OpIAddCarry";
         case spv::OpISubBorrow:
            return "OpISubBorrow";
         case spv::OpUMulExtended:
            return "OpUMulExtended";
         case spv::OpSMulExtended:
            return "OpSMulExtended";
         case spv::OpAny:
            return "OpAny";
         case spv::OpAll:
            return "OpAll";
         case spv::OpIsNan:
            return "OpIsNan";
         case spv::OpIsInf:
            return "OpIsInf";
         case spv::OpLogicalEqual:
            return "OpLogicalEqual";
         case spv::OpLogicalNotEqual:
            return "OpLogicalNotEqual";
         case spv::OpLogicalOr:
            return "OpLogicalOr";
         case spv::OpLogicalAnd:
            return "OpLogicalAnd";
         case spv::OpLogicalNot:
            return "OpLogicalNot";
         case spv::OpSelect:
            return "OpSelect";
         case spv::OpIEqual:
            return "OpIEqual";
         case spv::OpINotEqual:
            return "OpINotEqual";
         case spv::OpUGreaterThan:
            return "OpUGreaterThan";
         case spv::OpSGreaterThan:
            return "OpSGreaterThan";
         case spv::OpUGreaterThanEqual:
            return "OpUGreaterThanEqual";
         case spv::OpSGreaterThanEqual:
            return "OpSGreaterThanEqual";
         case spv::OpULessThan:
            return "OpULessThan";
         case spv::OpSLessThan:
            return "OpSLessThan";
         case spv::OpULessThanEqual:
            return "OpULessThanEqual";
         case spv::OpSLessThanEqual:
            return "OpSLessThanEqual";
         case spv::OpFOrdEqual:
            return "OpFOrdEqual";
         case spv::OpFUnordEqual:
            return "OpFUnordEqual";
         case spv::OpFOrdNotEqual:
            return "OpFOrdNotEqual";
         case spv::OpFUnordNotEqual:
            return "OpFUnordNotEqual";
         case spv::OpFOrdLessThan:
            return "OpFOrdLessThan";
         case spv::OpFUnordLessThan:
            return "OpFUnordLessThan";
         case spv::OpFOrdGreaterThan:
            return "OpFOrdGreaterThan";
         case spv::OpFUnordGreaterThan:
            return "OpFUnordGreaterThan";
         case spv::OpFOrdLessThanEqual:
            return "OpFOrdLessThanEqual";
         case spv::OpFUnordLessThanEqual:
            return "OpFUnordLessThanEqual";
         case spv::OpFOrdGreaterThanEqual:
            return "OpFOrdGreaterThanEqual";
         case spv::OpFUnordGreaterThanEqual:
            return "OpFUnordGreaterThanEqual";
         case spv::OpShiftRightLogical:
            return "OpShiftRightLogical";
         case spv::OpShiftRightArithmetic:
            return "OpShiftRightArithmetic";
         case spv::OpShiftLeftLogical:
            return "OpShiftLeftLogical";
         case spv::OpBitwiseOr:
            return "OpBitwiseOr";
         case spv::OpBitwiseXor:
            return "OpBitwiseXor";
         case spv::OpBitwiseAnd:
            return "OpBitwiseAnd";
         case spv::OpNot:
            return "OpNot";
         case spv::OpBitFieldInsert:
            return "OpBitFieldInsert";
         case spv::OpBitFieldSExtract:
            return "OpBitFieldSExtract";
         case spv::OpBitFieldUExtract:
            return "OpBitFieldUExtract";
         case spv::OpBitReverse:
            return "OpBitReverse";
         case spv::OpBitCount:
            return "OpBitCount";
         case spv::OpDPdx:
            return "OpDPdx";
         case spv::OpDPdy:
            return "OpDPdy";
         case spv::OpFwidth:
            return "OpFwidth";
         case spv::OpDPdxFine:
            return "OpDPdxFine";
         case spv::OpDPdyFine:
            return "OpDPdyFine";
         case spv::OpFwidthFine:
            return "OpFwidthFine";
         case spv::OpDPdxCoarse:
            return "OpDPdxCoarse";
         case spv::OpDPdyCoarse:
            return "OpDPdyCoarse";
         case spv::OpFwidthCoarse:
            return "OpFwidthCoarse";
         case spv::OpEmitVertex:
            return "OpEmitVertex";
         case spv::OpEndPrimitive:
            return "OpEndPrimitive";
         case spv::OpEmitStreamVertex:
            return "OpEmitStreamVertex";
         case spv::OpEndStreamPrimitive:
            return "OpEndStreamPrimitive";
         case spv::OpControlBarrier:
            return "OpControlBarrier";
         case spv::OpMemoryBarrier:
            return "OpMemoryBarrier";
         case spv::OpAtomicLoad:
            return "OpAtomicLoad";
         case spv::OpAtomicStore:
            return "OpAtomicStore";
         case spv::OpAtomicExchange:
            return "OpAtomicExchange";
         case spv::OpAtomicCompareExchange:
            return "OpAtomicCompareExchange";
         case spv::OpAtomicIIncrement:
            return "OpAtomicIIncrement";
         case spv::OpAtomicIDecrement:
            return "OpAtomicIDecrement";
         case spv::OpAtomicIAdd:
            return "OpAtomicIAdd";
         case spv::OpAtomicISub:
            return "OpAtomicISub";
         case spv::OpAtomicSMin:
            return "OpAtomicSMin";
         case spv::OpAtomicUMin:
            return "OpAtomicUMin";
         case spv::OpAtomicSMax:
            return "OpAtomicSMax";
         case spv::OpAtomicUMax:
            return "OpAtomicUMax";
         case spv::OpAtomicAnd:
            return "OpAtomicAnd";
         case spv::OpAtomicOr:
            return "OpAtomicOr";
         case spv::OpAtomicXor:
            return "OpAtomicXor";
         case spv::OpPhi:
            return "OpPhi";
         case spv::OpLoopMerge:
            return "OpLoopMerge";
         case spv::OpSelectionMerge:
            return "OpSelectionMerge";
         case spv::OpLabel:
            return "OpLabel";
         case spv::OpBranch:
            return "OpBranch";
         case spv::OpBranchConditional:
            return "OpBranchConditional";
         case spv::OpSwitch:
            return "OpSwitch";
         case spv::OpKill:
            return "OpKill";
         case spv::OpReturn:
            return "OpReturn";
         case spv::OpReturnValue:
            return "OpReturnValue";
         case spv::OpUnreachable:
            return "OpUnreachable";
         case spv::OpGroupAll:
            return "OpGroupAll";
         case spv::OpGroupAny:
            return "OpGroupAny";
         case spv::OpGroupBroadcast:
            return "OpGroupBroadcast";
         case spv::OpGroupIAdd:
            return "OpGroupIAdd";
         case spv::OpGroupFAdd:
            return "OpGroupFAdd";
         case spv::OpGroupFMin:
            return "OpGroupFMin";
         case spv::OpGroupUMin:
            return "OpGroupUMin";
         case spv::OpGroupSMin:
            return "OpGroupSMin";
         case spv::OpGroupFMax:
            return "OpGroupFMax";
         case spv::OpGroupUMax:
            return "OpGroupUMax";
         case spv::OpGroupSMax:
            return "OpGroupSMax";
         case spv::OpImageSparseSampleImplicitLod:
            return "OpImageSparseSampleImplicitLod";
         case spv::OpImageSparseSampleExplicitLod:
            return "OpImageSparseSampleExplicitLod";
         case spv::OpImageSparseSampleDrefImplicitLod:
            return "OpImageSparseSampleDrefImplicitLod";
         case spv::OpImageSparseSampleDrefExplicitLod:
            return "OpImageSparseSampleDrefExplicitLod";
         case spv::OpImageSparseSampleProjImplicitLod:
            return "OpImageSparseSampleProjImplicitLod";
         case spv::OpImageSparseSampleProjExplicitLod:
            return "OpImageSparseSampleProjExplicitLod";
         case spv::OpImageSparseSampleProjDrefImplicitLod:
            return "OpImageSparseSampleProjDrefImplicitLod";
         case spv::OpImageSparseSampleProjDrefExplicitLod:
            return "OpImageSparseSampleProjDrefExplicitLod";
         case spv::OpImageSparseFetch:
            return "OpImageSparseFetch";
         case spv::OpImageSparseGather:
            return "OpImageSparseGather";
         case spv::OpImageSparseDrefGather:
            return "OpImageSparseDrefGather";
         case spv::OpImageSparseTexelsResident:
            return "OpImageSparseTexelsResident";
         case spv::OpNoLine:
            return "OpNoLine";
         case spv::OpImageSparseRead:
            return "OpImageSparseRead";
         case spv::OpSizeOf:
            return "OpSizeOf";
         case spv::OpTypePipeStorage:
            return "OpTypePipeStorage";
         case spv::OpConstantPipeStorage:
            return "OpConstantPipeStorage";
         case spv::OpCreatePipeFromPipeStorage:
            return "OpCreatePipeFromPipeStorage";
         case spv::OpGetKernelLocalSizeForSubgroupCount:
            return "OpGetKernelLocalSizeForSubgroupCount";
         case spv::OpGetKernelMaxNumSubgroups:
            return "OpGetKernelMaxNumSubgroups";
         case spv::OpModuleProcessed:
            return "OpModuleProcessed";
         case spv::OpExecutionModeId:
            return "OpExecutionModeId";
         case spv::OpDecorateId:
            return "OpDecorateId";
         case spv::OpGroupNonUniformElect:
            return "OpGroupNonUniformElect";
         case spv::OpGroupNonUniformAll:
            return "OpGroupNonUniformAll";
         case spv::OpGroupNonUniformAny:
            return "OpGroupNonUniformAny";
         case spv::OpGroupNonUniformAllEqual:
            return "OpGroupNonUniformAllEqual";
         case spv::OpGroupNonUniformBroadcast:
            return "OpGroupNonUniformBroadcast";
         case spv::OpGroupNonUniformBroadcastFirst:
            return "OpGroupNonUniformBroadcastFirst";
         case spv::OpGroupNonUniformBallot:
            return "OpGroupNonUniformBallot";
         case spv::OpGroupNonUniformInverseBallot:
            return "OpGroupNonUniformInverseBallot";
         case spv::OpGroupNonUniformBallotBitExtract:
            return "OpGroupNonUniformBallotBitExtract";
         case spv::OpGroupNonUniformBallotBitCount:
            return "OpGroupNonUniformBallotBitCount";
         case spv::OpGroupNonUniformBallotFindLSB:
            return "OpGroupNonUniformBallotFindLSB";
         case spv::OpGroupNonUniformBallotFindMSB:
            return "OpGroupNonUniformBallotFindMSB";
         case spv::OpGroupNonUniformShuffle:
            return "OpGroupNonUniformShuffle";
         case spv::OpGroupNonUniformShuffleXor:
            return "OpGroupNonUniformShuffleXor";
         case spv::OpGroupNonUniformShuffleUp:
            return "OpGroupNonUniformShuffleUp";
         case spv::OpGroupNonUniformShuffleDown:
            return "OpGroupNonUniformShuffleDown";
         case spv::OpGroupNonUniformIAdd:
            return "OpGroupNonUniformIAdd";
         case spv::OpGroupNonUniformFAdd:
            return "OpGroupNonUniformFAdd";
         case spv::OpGroupNonUniformIMul:
            return "OpGroupNonUniformIMul";
         case spv::OpGroupNonUniformFMul:
            return "OpGroupNonUniformFMul";
         case spv::OpGroupNonUniformSMin:
            return "OpGroupNonUniformSMin";
         case spv::OpGroupNonUniformUMin:
            return "OpGroupNonUniformUMin";
         case spv::OpGroupNonUniformFMin:
            return "OpGroupNonUniformFMin";
         case spv::OpGroupNonUniformSMax:
            return "OpGroupNonUniformSMax";
         case spv::OpGroupNonUniformUMax:
            return "OpGroupNonUniformUMax";
         case spv::OpGroupNonUniformFMax:
            return "OpGroupNonUniformFMax";
         case spv::OpGroupNonUniformBitwiseAnd:
            return "OpGroupNonUniformBitwiseAnd";
         case spv::OpGroupNonUniformBitwiseOr:
            return "OpGroupNonUniformBitwiseOr";
         case spv::OpGroupNonUniformBitwiseXor:
            return "OpGroupNonUniformBitwiseXor";
         case spv::OpGroupNonUniformLogicalAnd:
            return "OpGroupNonUniformLogicalAnd";
         case spv::OpGroupNonUniformLogicalOr:
            return "OpGroupNonUniformLogicalOr";
         case spv::OpGroupNonUniformLogicalXor:
            return "OpGroupNonUniformLogicalXor";
         case spv::OpGroupNonUniformQuadBroadcast:
            return "OpGroupNonUniformQuadBroadcast";
         case spv::OpGroupNonUniformQuadSwap:
            return "OpGroupNonUniformQuadSwap";
         case spv::OpCopyLogical:
            return "OpCopyLogical";
         case spv::OpPtrEqual:
            return "OpPtrEqual";
         case spv::OpPtrNotEqual:
            return "OpPtrNotEqual";
         case spv::OpPtrDiff:
            return "OpPtrDiff";
         case spv::OpTerminateInvocation:
            return "OpTerminateInvocation";
         case spv::OpSubgroupBallotKHR:
            return "OpSubgroupBallotKHR";
         case spv::OpSubgroupFirstInvocationKHR:
            return "OpSubgroupFirstInvocationKHR";
         case spv::OpSubgroupAllKHR:
            return "OpSubgroupAllKHR";
         case spv::OpSubgroupAnyKHR:
            return "OpSubgroupAnyKHR";
         case spv::OpSubgroupAllEqualKHR:
            return "OpSubgroupAllEqualKHR";
         case spv::OpSubgroupReadInvocationKHR:
            return "OpSubgroupReadInvocationKHR";
         case spv::OpTraceRayKHR:
            return "OpTraceRayKHR";
         case spv::OpExecuteCallableKHR:
            return "OpExecuteCallableKHR";
         case spv::OpConvertUToAccelerationStructureKHR:
            return "OpConvertUToAccelerationStructureKHR";
         case spv::OpIgnoreIntersectionKHR:
            return "OpIgnoreIntersectionKHR";
         case spv::OpTerminateRayKHR:
            return "OpTerminateRayKHR";
         case spv::OpSDotKHR:
            return "OpSDotKHR";
         case spv::OpUDotKHR:
            return "OpUDotKHR";
         case spv::OpSUDotKHR:
            return "OpSUDotKHR";
         case spv::OpSDotAccSatKHR:
            return "OpSDotAccSatKHR";
         case spv::OpUDotAccSatKHR:
            return "OpUDotAccSatKHR";
         case spv::OpSUDotAccSatKHR:
            return "OpSUDotAccSatKHR";
         case spv::OpTypeRayQueryKHR:
            return "OpTypeRayQueryKHR";
         case spv::OpRayQueryInitializeKHR:
            return "OpRayQueryInitializeKHR";
         case spv::OpRayQueryTerminateKHR:
            return "OpRayQueryTerminateKHR";
         case spv::OpRayQueryGenerateIntersectionKHR:
            return "OpRayQueryGenerateIntersectionKHR";
         case spv::OpRayQueryConfirmIntersectionKHR:
            return "OpRayQueryConfirmIntersectionKHR";
         case spv::OpRayQueryProceedKHR:
            return "OpRayQueryProceedKHR";
         case spv::OpRayQueryGetIntersectionTypeKHR:
            return "OpRayQueryGetIntersectionTypeKHR";
         case spv::OpGroupIAddNonUniformAMD:
            return "OpGroupIAddNonUniformAMD";
         case spv::OpGroupFAddNonUniformAMD:
            return "OpGroupFAddNonUniformAMD";
         case spv::OpGroupFMinNonUniformAMD:
            return "OpGroupFMinNonUniformAMD";
         case spv::OpGroupUMinNonUniformAMD:
            return "OpGroupUMinNonUniformAMD";
         case spv::OpGroupSMinNonUniformAMD:
            return "OpGroupSMinNonUniformAMD";
         case spv::OpGroupFMaxNonUniformAMD:
            return "OpGroupFMaxNonUniformAMD";
         case spv::OpGroupUMaxNonUniformAMD:
            return "OpGroupUMaxNonUniformAMD";
         case spv::OpGroupSMaxNonUniformAMD:
            return "OpGroupSMaxNonUniformAMD";
         case spv::OpFragmentMaskFetchAMD:
            return "OpFragmentMaskFetchAMD";
         case spv::OpFragmentFetchAMD:
            return "OpFragmentFetchAMD";
         case spv::OpReadClockKHR:
            return "OpReadClockKHR";
         case spv::OpImageSampleFootprintNV:
            return "OpImageSampleFootprintNV";
         case spv::OpGroupNonUniformPartitionNV:
            return "OpGroupNonUniformPartitionNV";
         case spv::OpWritePackedPrimitiveIndices4x8NV:
            return "OpWritePackedPrimitiveIndices4x8NV";
         case spv::OpReportIntersectionKHR:
            return "OpReportIntersectionKHR";
         case spv::OpIgnoreIntersectionNV:
            return "OpIgnoreIntersectionNV";
         case spv::OpTerminateRayNV:
            return "OpTerminateRayNV";
         case spv::OpTraceNV:
            return "OpTraceNV";
         case spv::OpTraceMotionNV:
            return "OpTraceMotionNV";
         case spv::OpTraceRayMotionNV:
            return "OpTraceRayMotionNV";
         case spv::OpTypeAccelerationStructureKHR:
            return "OpTypeAccelerationStructureKHR";
         case spv::OpExecuteCallableNV:
            return "OpExecuteCallableNV";
         case spv::OpTypeCooperativeMatrixNV:
            return "OpTypeCooperativeMatrixNV";
         case spv::OpCooperativeMatrixLoadNV:
            return "OpCooperativeMatrixLoadNV";
         case spv::OpCooperativeMatrixStoreNV:
            return "OpCooperativeMatrixStoreNV";
         case spv::OpCooperativeMatrixMulAddNV:
            return "OpCooperativeMatrixMulAddNV";
         case spv::OpCooperativeMatrixLengthNV:
            return "OpCooperativeMatrixLengthNV";
         case spv::OpBeginInvocationInterlockEXT:
            return "OpBeginInvocationInterlockEXT";
         case spv::OpEndInvocationInterlockEXT:
            return "OpEndInvocationInterlockEXT";
         case spv::OpDemoteToHelperInvocationEXT:
            return "OpDemoteToHelperInvocationEXT";
         case spv::OpIsHelperInvocationEXT:
            return "OpIsHelperInvocationEXT";
         case spv::OpConvertUToImageNV:
            return "OpConvertUToImageNV";
         case spv::OpConvertUToSamplerNV:
            return "OpConvertUToSamplerNV";
         case spv::OpConvertImageToUNV:
            return "OpConvertImageToUNV";
         case spv::OpConvertSamplerToUNV:
            return "OpConvertSamplerToUNV";
         case spv::OpConvertUToSampledImageNV:
            return "OpConvertUToSampledImageNV";
         case spv::OpConvertSampledImageToUNV:
            return "OpConvertSampledImageToUNV";
         case spv::OpSamplerImageAddressingModeNV:
            return "OpSamplerImageAddressingModeNV";
         case spv::OpSubgroupShuffleINTEL:
            return "OpSubgroupShuffleINTEL";
         case spv::OpSubgroupShuffleDownINTEL:
            return "OpSubgroupShuffleDownINTEL";
         case spv::OpSubgroupShuffleUpINTEL:
            return "OpSubgroupShuffleUpINTEL";
         case spv::OpSubgroupShuffleXorINTEL:
            return "OpSubgroupShuffleXorINTEL";
         case spv::OpSubgroupBlockReadINTEL:
            return "OpSubgroupBlockReadINTEL";
         case spv::OpSubgroupBlockWriteINTEL:
            return "OpSubgroupBlockWriteINTEL";
         case spv::OpSubgroupImageBlockReadINTEL:
            return "OpSubgroupImageBlockReadINTEL";
         case spv::OpSubgroupImageBlockWriteINTEL:
            return "OpSubgroupImageBlockWriteINTEL";
         case spv::OpSubgroupImageMediaBlockReadINTEL:
            return "OpSubgroupImageMediaBlockReadINTEL";
         case spv::OpSubgroupImageMediaBlockWriteINTEL:
            return "OpSubgroupImageMediaBlockWriteINTEL";
         case spv::OpUCountLeadingZerosINTEL:
            return "OpUCountLeadingZerosINTEL";
         case spv::OpUCountTrailingZerosINTEL:
            return "OpUCountTrailingZerosINTEL";
         case spv::OpAbsISubINTEL:
            return "OpAbsISubINTEL";
         case spv::OpAbsUSubINTEL:
            return "OpAbsUSubINTEL";
         case spv::OpIAddSatINTEL:
            return "OpIAddSatINTEL";
         case spv::OpUAddSatINTEL:
            return "OpUAddSatINTEL";
         case spv::OpIAverageINTEL:
            return "OpIAverageINTEL";
         case spv::OpUAverageINTEL:
            return "OpUAverageINTEL";
         case spv::OpIAverageRoundedINTEL:
            return "OpIAverageRoundedINTEL";
         case spv::OpUAverageRoundedINTEL:
            return "OpUAverageRoundedINTEL";
         case spv::OpISubSatINTEL:
            return "OpISubSatINTEL";
         case spv::OpUSubSatINTEL:
            return "OpUSubSatINTEL";
         case spv::OpIMul32x16INTEL:
            return "OpIMul32x16INTEL";
         case spv::OpUMul32x16INTEL:
            return "OpUMul32x16INTEL";
         case spv::OpConstantFunctionPointerINTEL:
            return "OpConstantFunctionPointerINTEL";
         case spv::OpFunctionPointerCallINTEL:
            return "OpFunctionPointerCallINTEL";
         case spv::OpAsmTargetINTEL:
            return "OpAsmTargetINTEL";
         case spv::OpAsmINTEL:
            return "OpAsmINTEL";
         case spv::OpAsmCallINTEL:
            return "OpAsmCallINTEL";
         case spv::OpAtomicFMinEXT:
            return "OpAtomicFMinEXT";
         case spv::OpAtomicFMaxEXT:
            return "OpAtomicFMaxEXT";
         case spv::OpAssumeTrueKHR:
            return "OpAssumeTrueKHR";
         case spv::OpExpectKHR:
            return "OpExpectKHR";
         case spv::OpDecorateStringGOOGLE:
            return "OpDecorateStringGOOGLE";
         case spv::OpMemberDecorateStringGOOGLE:
            return "OpMemberDecorateStringGOOGLE";
         case spv::OpVariableLengthArrayINTEL:
            return "OpVariableLengthArrayINTEL";
         case spv::OpSaveMemoryINTEL:
            return "OpSaveMemoryINTEL";
         case spv::OpRestoreMemoryINTEL:
            return "OpRestoreMemoryINTEL";
         case spv::OpLoopControlINTEL:
            return "OpLoopControlINTEL";
         case spv::OpPtrCastToCrossWorkgroupINTEL:
            return "OpPtrCastToCrossWorkgroupINTEL";
         case spv::OpCrossWorkgroupCastToPtrINTEL:
            return "OpCrossWorkgroupCastToPtrINTEL";
         case spv::OpReadPipeBlockingINTEL:
            return "OpReadPipeBlockingINTEL";
         case spv::OpWritePipeBlockingINTEL:
            return "OpWritePipeBlockingINTEL";
         case spv::OpFPGARegINTEL:
            return "OpFPGARegINTEL";
         case spv::OpRayQueryGetRayTMinKHR:
            return "OpRayQueryGetRayTMinKHR";
         case spv::OpRayQueryGetRayFlagsKHR:
            return "OpRayQueryGetRayFlagsKHR";
         case spv::OpRayQueryGetIntersectionTKHR:
            return "OpRayQueryGetIntersectionTKHR";
         case spv::OpRayQueryGetIntersectionInstanceCustomIndexKHR:
            return "OpRayQueryGetIntersectionInstanceCustomIndexKHR";
         case spv::OpRayQueryGetIntersectionInstanceIdKHR:
            return "OpRayQueryGetIntersectionInstanceIdKHR";
         case spv::OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
            return "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR";
         case spv::OpRayQueryGetIntersectionGeometryIndexKHR:
            return "OpRayQueryGetIntersectionGeometryIndexKHR";
         case spv::OpRayQueryGetIntersectionPrimitiveIndexKHR:
            return "OpRayQueryGetIntersectionPrimitiveIndexKHR";
         case spv::OpRayQueryGetIntersectionBarycentricsKHR:
            return "OpRayQueryGetIntersectionBarycentricsKHR";
         case spv::OpRayQueryGetIntersectionFrontFaceKHR:
            return "OpRayQueryGetIntersectionFrontFaceKHR";
         case spv::OpRayQueryGetIntersectionCandidateAABBOpaqueKHR:
            return "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR";
         case spv::OpRayQueryGetIntersectionObjectRayDirectionKHR:
            return "OpRayQueryGetIntersectionObjectRayDirectionKHR";
         case spv::OpRayQueryGetIntersectionObjectRayOriginKHR:
            return "OpRayQueryGetIntersectionObjectRayOriginKHR";
         case spv::OpRayQueryGetWorldRayDirectionKHR:
            return "OpRayQueryGetWorldRayDirectionKHR";
         case spv::OpRayQueryGetWorldRayOriginKHR:
            return "OpRayQueryGetWorldRayOriginKHR";
         case spv::OpRayQueryGetIntersectionObjectToWorldKHR:
            return "OpRayQueryGetIntersectionObjectToWorldKHR";
         case spv::OpRayQueryGetIntersectionWorldToObjectKHR:
            return "OpRayQueryGetIntersectionWorldToObjectKHR";
         case spv::OpAtomicFAddEXT:
            return "OpAtomicFAddEXT";
         case spv::OpTypeBufferSurfaceINTEL:
            return "OpTypeBufferSurfaceINTEL";
         case spv::OpTypeStructContinuedINTEL:
            return "OpTypeStructContinuedINTEL";
         case spv::OpConstantCompositeContinuedINTEL:
            return "OpConstantCompositeContinuedINTEL";
         case spv::OpSpecConstantCompositeContinuedINTEL:
            return "OpSpecConstantCompositeContinuedINTEL";
        default:
            return "Unhandled Opcode";
    };
};
