// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See helper_file_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2015-2020 The Khronos Group Inc.
 * Copyright (c) 2015-2020 Valve Corporation
 * Copyright (c) 2015-2020 LunarG, Inc.
 * Copyright (c) 2015-2020 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@lunarg.com>
 * Author: Courtney Goeltzenleuchter <courtneygo@google.com>
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Chris Forbes <chrisforbes@google.com>
 * Author: John Zulauf<jzulauf@lunarg.com>
 *
 ****************************************************************************/

#pragma once

#include <array>
#include <map>
#include <stdint.h>
#include <vulkan/vulkan.h>

// clang-format off

using SyncStageAccessFlags = uint64_t;

// Unique number for each  stage/access combination
enum SyncStageAccessIndex {
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ = 0,
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 1,
    SYNC_VERTEX_INPUT_INDEX_READ = 2,
    SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ = 3,
    SYNC_VERTEX_SHADER_SHADER_READ = 4,
    SYNC_VERTEX_SHADER_SHADER_WRITE = 5,
    SYNC_VERTEX_SHADER_UNIFORM_READ = 6,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ = 7,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE = 8,
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ = 9,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ = 10,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE = 11,
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ = 12,
    SYNC_GEOMETRY_SHADER_SHADER_READ = 13,
    SYNC_GEOMETRY_SHADER_SHADER_WRITE = 14,
    SYNC_GEOMETRY_SHADER_UNIFORM_READ = 15,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT = 16,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT = 17,
    SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT = 18,
    SYNC_TASK_SHADER_NV_SHADER_READ = 19,
    SYNC_TASK_SHADER_NV_SHADER_WRITE = 20,
    SYNC_TASK_SHADER_NV_UNIFORM_READ = 21,
    SYNC_MESH_SHADER_NV_SHADER_READ = 22,
    SYNC_MESH_SHADER_NV_SHADER_WRITE = 23,
    SYNC_MESH_SHADER_NV_UNIFORM_READ = 24,
    SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV = 25,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 26,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 27,
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ = 28,
    SYNC_FRAGMENT_SHADER_SHADER_READ = 29,
    SYNC_FRAGMENT_SHADER_SHADER_WRITE = 30,
    SYNC_FRAGMENT_SHADER_UNIFORM_READ = 31,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 32,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 33,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ = 34,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT = 35,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE = 36,
    SYNC_COMPUTE_SHADER_SHADER_READ = 37,
    SYNC_COMPUTE_SHADER_SHADER_WRITE = 38,
    SYNC_COMPUTE_SHADER_UNIFORM_READ = 39,
    SYNC_TRANSFER_TRANSFER_READ = 40,
    SYNC_TRANSFER_TRANSFER_WRITE = 41,
    SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV = 42,
    SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV = 43,
    SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT = 44,
    SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR = 45,
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ = 46,
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE = 47,
    SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ = 48,
    SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR = 49,
    SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR = 50,
    SYNC_HOST_HOST_READ = 51,
    SYNC_HOST_HOST_WRITE = 52,
    SYNC_IMAGE_LAYOUT_TRANSITION = 53,
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER = 54,
};

// Unique bit for each  stage/access combination
enum SyncStageAccessFlagBits : SyncStageAccessFlags {
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT = SyncStageAccessFlags(1) << SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ,
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = SyncStageAccessFlags(1) << SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT,
    SYNC_VERTEX_INPUT_INDEX_READ_BIT = SyncStageAccessFlags(1) << SYNC_VERTEX_INPUT_INDEX_READ,
    SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT = SyncStageAccessFlags(1) << SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ,
    SYNC_VERTEX_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_READ,
    SYNC_VERTEX_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_WRITE,
    SYNC_VERTEX_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_VERTEX_SHADER_UNIFORM_READ,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE,
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE,
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ,
    SYNC_GEOMETRY_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_READ,
    SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_WRITE,
    SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_GEOMETRY_SHADER_UNIFORM_READ,
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT = SyncStageAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT,
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT = SyncStageAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT,
    SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT = SyncStageAccessFlags(1) << SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT,
    SYNC_TASK_SHADER_NV_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_TASK_SHADER_NV_SHADER_READ,
    SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_TASK_SHADER_NV_SHADER_WRITE,
    SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_TASK_SHADER_NV_UNIFORM_READ,
    SYNC_MESH_SHADER_NV_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_MESH_SHADER_NV_SHADER_READ,
    SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_MESH_SHADER_NV_SHADER_WRITE,
    SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_MESH_SHADER_NV_UNIFORM_READ,
    SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV = SyncStageAccessFlags(1) << SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = SyncStageAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT = SyncStageAccessFlags(1) << SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ,
    SYNC_FRAGMENT_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_READ,
    SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_WRITE,
    SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_FRAGMENT_SHADER_UNIFORM_READ,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = SyncStageAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT = SyncStageAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT = SyncStageAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE,
    SYNC_COMPUTE_SHADER_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_READ,
    SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_WRITE,
    SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_COMPUTE_SHADER_UNIFORM_READ,
    SYNC_TRANSFER_TRANSFER_READ_BIT = SyncStageAccessFlags(1) << SYNC_TRANSFER_TRANSFER_READ,
    SYNC_TRANSFER_TRANSFER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_TRANSFER_TRANSFER_WRITE,
    SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV = SyncStageAccessFlags(1) << SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV,
    SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV = SyncStageAccessFlags(1) << SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV,
    SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT = SyncStageAccessFlags(1) << SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT,
    SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR = SyncStageAccessFlags(1) << SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR,
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT = SyncStageAccessFlags(1) << SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ,
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE,
    SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT = SyncStageAccessFlags(1) << SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ,
    SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR = SyncStageAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR,
    SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR = SyncStageAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR,
    SYNC_HOST_HOST_READ_BIT = SyncStageAccessFlags(1) << SYNC_HOST_HOST_READ,
    SYNC_HOST_HOST_WRITE_BIT = SyncStageAccessFlags(1) << SYNC_HOST_HOST_WRITE,
    SYNC_IMAGE_LAYOUT_TRANSITION_BIT = SyncStageAccessFlags(1) << SYNC_IMAGE_LAYOUT_TRANSITION,
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT = SyncStageAccessFlags(1) << SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER,
};

// Map of the StageAccessIndices from the StageAccess Bit
static std::map<SyncStageAccessFlags, SyncStageAccessIndex> syncStageAccessIndexByStageAccessBit  = {
    { SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT, SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ },
    { SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT },
    { SYNC_VERTEX_INPUT_INDEX_READ_BIT, SYNC_VERTEX_INPUT_INDEX_READ },
    { SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ },
    { SYNC_VERTEX_SHADER_SHADER_READ_BIT, SYNC_VERTEX_SHADER_SHADER_READ },
    { SYNC_VERTEX_SHADER_SHADER_WRITE_BIT, SYNC_VERTEX_SHADER_SHADER_WRITE },
    { SYNC_VERTEX_SHADER_UNIFORM_READ_BIT, SYNC_VERTEX_SHADER_UNIFORM_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE },
    { SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE },
    { SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT, SYNC_GEOMETRY_SHADER_SHADER_WRITE },
    { SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT, SYNC_GEOMETRY_SHADER_UNIFORM_READ },
    { SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT },
    { SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT },
    { SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT },
    { SYNC_TASK_SHADER_NV_SHADER_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_READ },
    { SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT, SYNC_TASK_SHADER_NV_SHADER_WRITE },
    { SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT, SYNC_TASK_SHADER_NV_UNIFORM_READ },
    { SYNC_MESH_SHADER_NV_SHADER_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_READ },
    { SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT, SYNC_MESH_SHADER_NV_SHADER_WRITE },
    { SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT, SYNC_MESH_SHADER_NV_UNIFORM_READ },
    { SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV, SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV },
    { SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
    { SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE },
    { SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT, SYNC_FRAGMENT_SHADER_SHADER_WRITE },
    { SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT, SYNC_FRAGMENT_SHADER_UNIFORM_READ },
    { SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
    { SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE },
    { SYNC_COMPUTE_SHADER_SHADER_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_READ },
    { SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT, SYNC_COMPUTE_SHADER_SHADER_WRITE },
    { SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT, SYNC_COMPUTE_SHADER_UNIFORM_READ },
    { SYNC_TRANSFER_TRANSFER_READ_BIT, SYNC_TRANSFER_TRANSFER_READ },
    { SYNC_TRANSFER_TRANSFER_WRITE_BIT, SYNC_TRANSFER_TRANSFER_WRITE },
    { SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV },
    { SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV },
    { SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT },
    { SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR },
    { SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT, SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ },
    { SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE },
    { SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR },
    { SYNC_HOST_HOST_READ_BIT, SYNC_HOST_HOST_READ },
    { SYNC_HOST_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE },
    { SYNC_IMAGE_LAYOUT_TRANSITION_BIT, SYNC_IMAGE_LAYOUT_TRANSITION },
    { SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT, SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER },
};

struct SyncStageAccessInfoType {
    const char *name;
    VkPipelineStageFlagBits stage_mask;
    VkAccessFlagBits access_mask;
    SyncStageAccessIndex stage_access_index;
    SyncStageAccessFlagBits stage_access_bit;
};

// Array of text names and component masks for each stage/access index
static std::array<SyncStageAccessInfoType, 55> syncStageAccessInfoByStageAccessIndex = { {
    {
        "SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ",
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT,
        VK_ACCESS_INDIRECT_COMMAND_READ_BIT,
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ,
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT

    },
    {
        "SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT",
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT,
        VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT,
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT,
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT

    },
    {
        "SYNC_VERTEX_INPUT_INDEX_READ",
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT,
        VK_ACCESS_INDEX_READ_BIT,
        SYNC_VERTEX_INPUT_INDEX_READ,
        SYNC_VERTEX_INPUT_INDEX_READ_BIT

    },
    {
        "SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ",
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT,
        VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT,
        SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ,
        SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT

    },
    {
        "SYNC_VERTEX_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_VERTEX_SHADER_SHADER_READ,
        SYNC_VERTEX_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_VERTEX_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_VERTEX_SHADER_SHADER_WRITE,
        SYNC_VERTEX_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_VERTEX_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_VERTEX_SHADER_UNIFORM_READ,
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_GEOMETRY_SHADER_SHADER_READ,
        SYNC_GEOMETRY_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_GEOMETRY_SHADER_SHADER_WRITE,
        SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_GEOMETRY_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_GEOMETRY_SHADER_UNIFORM_READ,
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT",
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT,
        VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT,
        SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT,
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT

    },
    {
        "SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT",
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT,
        VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT,
        SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT,
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT

    },
    {
        "SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT",
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT,
        VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT,
        SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT,
        SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT

    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_READ",
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_TASK_SHADER_NV_SHADER_READ,
        SYNC_TASK_SHADER_NV_SHADER_READ_BIT

    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_WRITE",
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_TASK_SHADER_NV_SHADER_WRITE,
        SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT

    },
    {
        "SYNC_TASK_SHADER_NV_UNIFORM_READ",
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_TASK_SHADER_NV_UNIFORM_READ,
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT

    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_READ",
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_MESH_SHADER_NV_SHADER_READ,
        SYNC_MESH_SHADER_NV_SHADER_READ_BIT

    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_WRITE",
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_MESH_SHADER_NV_SHADER_WRITE,
        SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT

    },
    {
        "SYNC_MESH_SHADER_NV_UNIFORM_READ",
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_MESH_SHADER_NV_UNIFORM_READ,
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT

    },
    {
        "SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV",
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV,
        VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV,
        SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV,
        SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV

    },
    {
        "SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT

    },
    {
        "SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT

    },
    {
        "SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT,
        VK_ACCESS_INPUT_ATTACHMENT_READ_BIT,
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ,
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT

    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_FRAGMENT_SHADER_SHADER_READ,
        SYNC_FRAGMENT_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_FRAGMENT_SHADER_SHADER_WRITE,
        SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_FRAGMENT_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_FRAGMENT_SHADER_UNIFORM_READ,
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT

    },
    {
        "SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT

    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_COLOR_ATTACHMENT_READ_BIT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT

    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT",
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT

    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT

    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_READ",
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_COMPUTE_SHADER_SHADER_READ,
        SYNC_COMPUTE_SHADER_SHADER_READ_BIT

    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_WRITE",
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_COMPUTE_SHADER_SHADER_WRITE,
        SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT

    },
    {
        "SYNC_COMPUTE_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_COMPUTE_SHADER_UNIFORM_READ,
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT

    },
    {
        "SYNC_TRANSFER_TRANSFER_READ",
        VK_PIPELINE_STAGE_TRANSFER_BIT,
        VK_ACCESS_TRANSFER_READ_BIT,
        SYNC_TRANSFER_TRANSFER_READ,
        SYNC_TRANSFER_TRANSFER_READ_BIT

    },
    {
        "SYNC_TRANSFER_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_TRANSFER_BIT,
        VK_ACCESS_TRANSFER_WRITE_BIT,
        SYNC_TRANSFER_TRANSFER_WRITE,
        SYNC_TRANSFER_TRANSFER_WRITE_BIT

    },
    {
        "SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV",
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV,
        VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV,
        SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV,
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV

    },
    {
        "SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV",
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV,
        VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV,
        SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV,
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV

    },
    {
        "SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT",
        VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT,
        VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT,
        SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT,
        SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT

    },
    {
        "SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR",
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR,
        SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR

    },
    {
        "SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ",
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_SHADER_READ_BIT,
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ,
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT

    },
    {
        "SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE",
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_SHADER_WRITE_BIT,
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE,
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT

    },
    {
        "SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ",
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_UNIFORM_READ_BIT,
        SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ,
        SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT

    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR",
        VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR

    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR",
        VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR

    },
    {
        "SYNC_HOST_HOST_READ",
        VK_PIPELINE_STAGE_HOST_BIT,
        VK_ACCESS_HOST_READ_BIT,
        SYNC_HOST_HOST_READ,
        SYNC_HOST_HOST_READ_BIT

    },
    {
        "SYNC_HOST_HOST_WRITE",
        VK_PIPELINE_STAGE_HOST_BIT,
        VK_ACCESS_HOST_WRITE_BIT,
        SYNC_HOST_HOST_WRITE,
        SYNC_HOST_HOST_WRITE_BIT

    },
    {
        "SYNC_IMAGE_LAYOUT_TRANSITION",
        VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM,
        VK_ACCESS_FLAG_BITS_MAX_ENUM,
        SYNC_IMAGE_LAYOUT_TRANSITION,
        SYNC_IMAGE_LAYOUT_TRANSITION_BIT

    },
    {
        "SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER",
        VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM,
        VK_ACCESS_FLAG_BITS_MAX_ENUM,
        SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER,
        SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT

    },
} };

// Constants defining the mask of all read and write stage_access states
static SyncStageAccessFlags syncStageAccessReadMask = ( //  Mask of all read StageAccess bits
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
    SYNC_VERTEX_INPUT_INDEX_READ_BIT |
    SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT |
    SYNC_VERTEX_SHADER_SHADER_READ_BIT |
    SYNC_VERTEX_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_READ_BIT |
    SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT |
    SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT |
    SYNC_TASK_SHADER_NV_SHADER_READ_BIT |
    SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT |
    SYNC_MESH_SHADER_NV_SHADER_READ_BIT |
    SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT |
    SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_READ_BIT |
    SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
    SYNC_COMPUTE_SHADER_SHADER_READ_BIT |
    SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT |
    SYNC_TRANSFER_TRANSFER_READ_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV |
    SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT |
    SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR |
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT |
    SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR |
    SYNC_HOST_HOST_READ_BIT
);

static SyncStageAccessFlags syncStageAccessWriteMask = ( //  Mask of all write StageAccess bits
    SYNC_VERTEX_SHADER_SHADER_WRITE_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT |
    SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT |
    SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT |
    SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT |
    SYNC_TRANSFER_TRANSFER_WRITE_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV |
    SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR |
    SYNC_HOST_HOST_WRITE_BIT |
    SYNC_IMAGE_LAYOUT_TRANSITION_BIT |
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT
);

// Bit order mask of stage_access bit for each stage
static std::map<VkPipelineStageFlags, SyncStageAccessFlags> syncStageAccessMaskByStageBit = {
    { VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, (
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, (
        SYNC_VERTEX_INPUT_INDEX_READ_BIT |
        SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT
    )},
    { VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, (
        SYNC_VERTEX_SHADER_SHADER_READ_BIT |
        SYNC_VERTEX_SHADER_SHADER_WRITE_BIT |
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, (
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, (
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, (
        SYNC_GEOMETRY_SHADER_SHADER_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT |
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, (
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT |
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, (
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, (
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT |
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, (
        SYNC_COMPUTE_SHADER_SHADER_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT |
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_TRANSFER_BIT, (
        SYNC_TRANSFER_TRANSFER_READ_BIT |
        SYNC_TRANSFER_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_HOST_BIT, (
        SYNC_HOST_HOST_READ_BIT |
        SYNC_HOST_HOST_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV, (
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV |
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV
    )},
    { VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT, SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV, (
        SYNC_TASK_SHADER_NV_SHADER_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT |
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV, (
        SYNC_MESH_SHADER_NV_SHADER_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT |
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR, (
        SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT |
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT |
        SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV, SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV},
    { VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT, (
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, (
        SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR
    )},
};

// Bit order mask of stage_access bit for each access
static std::map<VkAccessFlags, SyncStageAccessFlags> syncStageAccessMaskByAccessBit = {
    { VK_ACCESS_INDIRECT_COMMAND_READ_BIT, SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT},
    { VK_ACCESS_INDEX_READ_BIT, SYNC_VERTEX_INPUT_INDEX_READ_BIT},
    { VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ_BIT},
    { VK_ACCESS_UNIFORM_READ_BIT, (
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT |
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT |
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT |
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT |
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT |
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT |
        SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ_BIT
    )},
    { VK_ACCESS_INPUT_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT},
    { VK_ACCESS_SHADER_READ_BIT, (
        SYNC_VERTEX_SHADER_SHADER_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_READ_BIT |
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ_BIT
    )},
    { VK_ACCESS_SHADER_WRITE_BIT, (
        SYNC_VERTEX_SHADER_SHADER_WRITE_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_WRITE_BIT |
        SYNC_TASK_SHADER_NV_SHADER_WRITE_BIT |
        SYNC_MESH_SHADER_NV_SHADER_WRITE_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_WRITE_BIT |
        SYNC_COMPUTE_SHADER_SHADER_WRITE_BIT |
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE_BIT
    )},
    { VK_ACCESS_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT},
    { VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT},
    { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT
    )},
    { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_ACCESS_TRANSFER_READ_BIT, SYNC_TRANSFER_TRANSFER_READ_BIT},
    { VK_ACCESS_TRANSFER_WRITE_BIT, SYNC_TRANSFER_TRANSFER_WRITE_BIT},
    { VK_ACCESS_HOST_READ_BIT, SYNC_HOST_HOST_READ_BIT},
    { VK_ACCESS_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE_BIT},
    { VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV},
    { VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV},
    { VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT},
    { VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT},
    { VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR, (
        SYNC_RAY_TRACING_SHADER_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_READ_BIT_KHR
    )},
    { VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_BIT_KHR_ACCELERATION_STRUCTURE_WRITE_BIT_KHR},
    { VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV, SYNC_SHADING_RATE_IMAGE_BIT_NV_SHADING_RATE_IMAGE_READ_BIT_NV},
    { VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT},
    { VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT},
    { VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT},
    { VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT},
    { VK_ACCESS_MEMORY_READ_BIT, syncStageAccessReadMask},
    { VK_ACCESS_MEMORY_WRITE_BIT, syncStageAccessWriteMask},
};

// stage_access index for each stage and access
static std::map<VkPipelineStageFlags, std::map<VkAccessFlags, SyncStageAccessIndex>> syncStageAccessIndexByStageAndAccess = {
    { VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, {
        { VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_READ_KHR },
        { VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_KHR_ACCELERATION_STRUCTURE_WRITE_KHR }
    } },
    { VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, {
        { VK_ACCESS_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ },
        { VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT },
        { VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV, {
        { VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV },
        { VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV }
    } },
    { VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_COMPUTE_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_COMPUTE_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT, {
        { VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, {
        { VK_ACCESS_INDIRECT_COMMAND_READ_BIT, SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ },
        { VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, {
        { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
        { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT, {
        { VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, {
        { VK_ACCESS_INPUT_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ },
        { VK_ACCESS_SHADER_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_FRAGMENT_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_FRAGMENT_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_GEOMETRY_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_GEOMETRY_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_HOST_BIT, {
        { VK_ACCESS_HOST_READ_BIT, SYNC_HOST_HOST_READ },
        { VK_ACCESS_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE }
    } },
    { VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, {
        { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
        { VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_MESH_SHADER_NV_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_MESH_SHADER_NV_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR, {
        { VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_RAY_TRACING_SHADER_KHR_ACCELERATION_STRUCTURE_READ_KHR },
        { VK_ACCESS_SHADER_READ_BIT, SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV, {
        { VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV, SYNC_SHADING_RATE_IMAGE_NV_SHADING_RATE_IMAGE_READ_NV }
    } },
    { VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_TASK_SHADER_NV_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_TASK_SHADER_NV_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_TRANSFER_BIT, {
        { VK_ACCESS_TRANSFER_READ_BIT, SYNC_TRANSFER_TRANSFER_READ },
        { VK_ACCESS_TRANSFER_WRITE_BIT, SYNC_TRANSFER_TRANSFER_WRITE }
    } },
    { VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT, {
        { VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT },
        { VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT }
    } },
    { VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, {
        { VK_ACCESS_INDEX_READ_BIT, SYNC_VERTEX_INPUT_INDEX_READ },
        { VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_INPUT_VERTEX_ATTRIBUTE_READ }
    } },
    { VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, {
        { VK_ACCESS_SHADER_READ_BIT, SYNC_VERTEX_SHADER_SHADER_READ },
        { VK_ACCESS_SHADER_WRITE_BIT, SYNC_VERTEX_SHADER_SHADER_WRITE },
        { VK_ACCESS_UNIFORM_READ_BIT, SYNC_VERTEX_SHADER_UNIFORM_READ }
    } },
};

// Pipeline stages corresponding to VK_PIPELINE_STAGE_ALL_COMMANDS_BIT for each VkQueueFlagBits
static std::map<VkQueueFlagBits, VkPipelineStageFlags> syncAllCommandStagesByQueueFlags = {
    { VK_QUEUE_COMPUTE_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFER_BIT |
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_HOST_BIT
    )},
    { VK_QUEUE_GRAPHICS_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_TRANSFER_BIT |
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_HOST_BIT
    )},
    { VK_QUEUE_TRANSFER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_TRANSFER_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_HOST_BIT
    )},
};

// Masks of logically earlier stage flags for a given stage flag
static std::map<VkPipelineStageFlagBits, VkPipelineStageFlags> syncLogicallyEarlierStages = {
    { VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV
    )},
    { VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV
    )},
    { VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV
    )},
    { VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT
    )},
    { VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT
    )},
    { VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_TRANSFER_BIT, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFER_BIT |
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
};

// Masks of logically later stage flags for a given stage flag
static std::map<VkPipelineStageFlagBits, VkPipelineStageFlags> syncLogicallyLaterStages = {
    { VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT, (
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFER_BIT |
        VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, (
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT |
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, (
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, (
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, (
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, (
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, (
        VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT, (
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT, (
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV |
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV, (
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, (
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_TRANSFER_BIT, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT, VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT},
};

struct SyncShaderStageAccess {
    SyncStageAccessIndex shader_read;
    SyncStageAccessIndex shader_write;
    SyncStageAccessIndex uniform_read;
};

static std::map<VkShaderStageFlagBits, SyncShaderStageAccess> syncStageAccessMaskByShaderStage = {
    {VK_SHADER_STAGE_VERTEX_BIT, {
        SYNC_VERTEX_SHADER_SHADER_READ, SYNC_VERTEX_SHADER_SHADER_WRITE, SYNC_VERTEX_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, {
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_READ, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_WRITE, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, {
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_READ, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_WRITE, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_GEOMETRY_BIT, {
        SYNC_GEOMETRY_SHADER_SHADER_READ, SYNC_GEOMETRY_SHADER_SHADER_WRITE, SYNC_GEOMETRY_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_FRAGMENT_BIT, {
        SYNC_FRAGMENT_SHADER_SHADER_READ, SYNC_FRAGMENT_SHADER_SHADER_WRITE, SYNC_FRAGMENT_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_COMPUTE_BIT, {
        SYNC_COMPUTE_SHADER_SHADER_READ, SYNC_COMPUTE_SHADER_SHADER_WRITE, SYNC_COMPUTE_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_RAYGEN_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_ANY_HIT_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_MISS_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_INTERSECTION_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_CALLABLE_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_KHR_SHADER_READ, SYNC_RAY_TRACING_SHADER_KHR_SHADER_WRITE, SYNC_RAY_TRACING_SHADER_KHR_UNIFORM_READ}},
    {VK_SHADER_STAGE_TASK_BIT_NV, {
        SYNC_TASK_SHADER_NV_SHADER_READ, SYNC_TASK_SHADER_NV_SHADER_WRITE, SYNC_TASK_SHADER_NV_UNIFORM_READ}},
    {VK_SHADER_STAGE_MESH_BIT_NV, {
        SYNC_MESH_SHADER_NV_SHADER_READ, SYNC_MESH_SHADER_NV_SHADER_WRITE, SYNC_MESH_SHADER_NV_UNIFORM_READ}},
};
