/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.reference;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.reference.modules.XMLResourceImpl;
import org.xmldb.api.sdk.SimpleResourceSet;

public class ResourceSetImpl
extends SimpleResourceSet {
    public ResourceSetImpl(Collection collection) throws XMLDBException {
        this.collection = collection;
    }

    public void addResource(String string, NodeList nodeList) throws XMLDBException {
        int n = 0;
        while (n < nodeList.getLength()) {
            try {
                Node node = nodeList.item(n);
                XMLResourceImpl xMLResourceImpl = new XMLResourceImpl(this.collection, null, string, this.serialize(node));
                this.resources.add(xMLResourceImpl);
            }
            catch (Exception exception) {
                throw new XMLDBException(0, (Throwable)exception);
            }
            ++n;
        }
    }

    public Resource getMembersAsResource() throws XMLDBException {
        Document document = this.buildMembersAsResourceDocument();
        XMLResourceImpl xMLResourceImpl = new XMLResourceImpl(this.collection, null, null, this.serialize(document));
        return xMLResourceImpl;
    }

    public String serialize(Node node) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            switch (node.getNodeType()) {
                case 9: {
                    xMLSerializer.serialize((Document)node);
                    break;
                }
                case 1: {
                    xMLSerializer.serialize((Element)node);
                    break;
                }
                case 11: {
                    xMLSerializer.serialize((DocumentFragment)node);
                }
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

