/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Available
extends Task
implements Condition {
    private String property;
    private String classname;
    private String file;
    private Path filepath;
    private String resource;
    private FileDir type;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";
    private boolean isTask = false;
    private boolean ignoreSystemclasses = false;

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFilepath(Path filepath) {
        this.createFilepath().append(filepath);
    }

    public Path createFilepath() {
        if (this.filepath == null) {
            this.filepath = new Path(this.getProject());
        }
        return this.filepath.createPath();
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setClassname(String classname) {
        if (!"".equals(classname)) {
            this.classname = classname;
        }
    }

    public void setFile(File file) {
        this.file = FileUtils.newFileUtils().removeLeadingPath(this.getProject().getBaseDir(), file);
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setType(String type) {
        this.log("DEPRECATED - The setType(String) method has been deprecated. Use setType(Available.FileDir) instead.");
        this.type = new FileDir();
        this.type.setValue(type);
    }

    public void setType(FileDir type) {
        this.type = type;
    }

    public void setIgnoresystemclasses(boolean ignore) {
        this.ignoreSystemclasses = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.getLocation());
        }
        this.isTask = true;
        try {
            if (this.eval()) {
                String oldvalue = this.getProject().getProperty(this.property);
                if (null != oldvalue && !oldvalue.equals(this.value)) {
                    this.log("DEPRECATED - <available> used to override an existing property." + StringUtils.LINE_SEP + "  Build file should not reuse the same property" + " name for different values.");
                }
                this.getProject().setProperty(this.property, this.value);
            }
        }
        finally {
            this.isTask = false;
        }
    }

    public boolean eval() throws BuildException {
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.getLocation());
        }
        if (this.type != null && this.file == null) {
            throw new BuildException("The type attribute is only valid when specifying the file attribute.", this.getLocation());
        }
        if (this.classpath != null) {
            this.classpath.setProject(this.getProject());
            this.loader = new AntClassLoader(this.getProject(), this.classpath);
        }
        String appendix = "";
        if (this.isTask) {
            appendix = " to set property " + this.property;
        } else {
            this.setTaskName("available");
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.log("Unable to load class " + this.classname + appendix, 3);
            return false;
        }
        if (this.file != null && !this.checkFile()) {
            if (this.type != null) {
                this.log("Unable to find " + this.type + " " + this.file + appendix, 3);
            } else {
                this.log("Unable to find " + this.file + appendix, 3);
            }
            return false;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.log("Unable to load resource " + this.resource + appendix, 3);
            return false;
        }
        if (this.loader != null) {
            this.loader.cleanup();
            this.loader = null;
        }
        if (!this.isTask) {
            this.setTaskName(null);
        }
        return true;
    }

    private boolean checkFile() {
        if (this.filepath == null) {
            return this.checkFile(this.getProject().resolveFile(this.file), this.file);
        }
        String[] paths = this.filepath.list();
        for (int i = 0; i < paths.length; ++i) {
            File grandParent;
            this.log("Searching " + paths[i], 4);
            File path = new File(paths[i]);
            if (path.exists() && this.file.equals(paths[i])) {
                if (this.type == null) {
                    this.log("Found: " + path, 3);
                    return true;
                }
                if (this.type.isDir() && path.isDirectory()) {
                    this.log("Found directory: " + path, 3);
                    return true;
                }
                if (this.type.isFile() && path.isFile()) {
                    this.log("Found file: " + path, 3);
                    return true;
                }
                return false;
            }
            FileUtils fileUtils = FileUtils.newFileUtils();
            File parent = fileUtils.getParentFile(path);
            if (parent != null && parent.exists() && this.file.equals(parent.getAbsolutePath())) {
                if (this.type == null) {
                    this.log("Found: " + parent, 3);
                    return true;
                }
                if (this.type.isDir()) {
                    this.log("Found directory: " + parent, 3);
                    return true;
                }
                return false;
            }
            if (path.exists() && path.isDirectory() && this.checkFile(new File(path, this.file), this.file + " in " + path)) {
                return true;
            }
            if (parent != null && parent.exists() && this.checkFile(new File(parent, this.file), this.file + " in " + parent)) {
                return true;
            }
            if (parent == null || (grandParent = fileUtils.getParentFile(parent)) == null || !grandParent.exists() || !this.checkFile(new File(grandParent, this.file), this.file + " in " + grandParent)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFile(File f, String text) {
        if (this.type != null) {
            if (this.type.isDir()) {
                if (f.isDirectory()) {
                    this.log("Found directory: " + text, 3);
                }
                return f.isDirectory();
            }
            if (this.type.isFile()) {
                if (f.isFile()) {
                    this.log("Found file: " + text, 3);
                }
                return f.isFile();
            }
        }
        if (f.exists()) {
            this.log("Found: " + text, 3);
        }
        return f.exists();
    }

    private boolean checkResource(String resource) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(resource) != null;
        }
        ClassLoader cL = this.getClass().getClassLoader();
        if (cL != null) {
            return cL.getResourceAsStream(resource) != null;
        }
        return ClassLoader.getSystemResourceAsStream(resource) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClass(String classname) {
        try {
            Class<?> requiredClass = null;
            if (this.ignoreSystemclasses) {
                this.loader = new AntClassLoader(null, this.getProject(), this.classpath, false);
                if (this.loader == null) return false;
                try {
                    requiredClass = this.loader.findClass(classname);
                }
                catch (SecurityException se) {
                    return true;
                }
            } else {
                ClassLoader l;
                requiredClass = this.loader != null ? this.loader.loadClass(classname) : ((l = this.getClass().getClassLoader()) != null ? l.loadClass(classname) : Class.forName(classname));
            }
            AntClassLoader.initializeClass(requiredClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.log("class \"" + classname + "\" was not found", 4);
            return false;
        }
        catch (NoClassDefFoundError e) {
            this.log("Could not load dependent class \"" + e.getMessage() + "\" for class \"" + classname + "\"", 4);
            return false;
        }
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] values = new String[]{"file", "dir"};

        public String[] getValues() {
            return values;
        }

        public boolean isDir() {
            return "dir".equalsIgnoreCase(this.getValue());
        }

        public boolean isFile() {
            return "file".equalsIgnoreCase(this.getValue());
        }
    }
}

